/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.server.stub.mirror;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.LinkedHashMap;

public class DescriptorUtils {
    public static String generateDescriptor(String key, String name, String selfUrl, String installedUrl, String uninstalledUrl, String enabledUrl, String disabledUrl, String webhookEventsUrl, String baseUrl) {
        LinkedHashMap<String, String> descriptor = new LinkedHashMap<String, String>();
        descriptor.put("key", key);
        descriptor.put("name", name);
        descriptor.put("vendor", (String)ImmutableMap.of((Object)"name", (Object)"Atlassian", (Object)"url", (Object)"http://www.atlassian.com"));
        descriptor.put("links", (String)ImmutableMap.of((Object)"self", (Object)selfUrl));
        descriptor.put("lifecycle", (String)ImmutableMap.builder().put((Object)"installed", (Object)installedUrl).put((Object)"uninstalled", (Object)uninstalledUrl).put((Object)"enabled", (Object)enabledUrl).put((Object)"disabled", (Object)disabledUrl).build());
        descriptor.put("baseUrl", baseUrl);
        descriptor.put("authentication", (String)ImmutableMap.of((Object)"type", (Object)"jwt"));
        descriptor.put("scopes", (String)ImmutableList.of((Object)"read"));
        descriptor.put("modules", (String)ImmutableMap.of((Object)"webhooks", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"event", (Object)"project:*", (Object)"url", (Object)webhookEventsUrl), (Object)ImmutableMap.of((Object)"event", (Object)"repo:*", (Object)"url", (Object)webhookEventsUrl))));
        try {
            return new ObjectMapper().writeValueAsString(descriptor);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

