/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.commit;

import com.atlassian.bitbucket.test.rest.AbstractRestRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class RestCommitMergeBaseRequest
extends AbstractRestRequest {
    private final String commitId;
    private final String otherCommitId;

    private RestCommitMergeBaseRequest(Builder builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.otherCommitId = builder.otherCommitId;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public String getOtherCommitId() {
        return this.otherCommitId;
    }

    @Override
    @Nonnull
    public Map<String, Object> toQueryParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("otherCommitId", this.otherCommitId);
        return params;
    }

    public static class Builder
    extends AbstractRestRequest.AbstractBuilder<Builder, RestCommitMergeBaseRequest> {
        private final String commitId;
        private String otherCommitId;

        public Builder(@Nonnull String commitId) {
            this.commitId = Objects.requireNonNull(commitId, "commitId");
        }

        public Builder(@Nonnull RestCommitMergeBaseRequest request) {
            super(request);
            this.commitId = request.getCommitId();
            this.status(Response.Status.NO_CONTENT);
        }

        @Override
        @Nonnull
        public RestCommitMergeBaseRequest build() {
            return new RestCommitMergeBaseRequest(this);
        }

        @Nonnull
        public Builder otherCommitId(@Nonnull String value) {
            this.otherCommitId = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

