/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import io.restassured.RestAssured;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matchers;

public class RestCommentUtils {
    public static Response addDiffComment(String commentator, String file, String url, CommentSeverity severity, DiffFileType fileType, String text, int line, DiffSegmentType lineType) {
        return (Response)((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)text), new Object[0]).body("id", Matchers.notNullValue(), new Object[0]).body("version", Matchers.equalTo((Object)0), new Object[0]).body("createdDate", Matchers.notNullValue(), new Object[0]).body("updatedDate", Matchers.notNullValue(), new Object[0]).body("author", Matchers.notNullValue(), new Object[0]).body("author.name", Matchers.equalTo((Object)commentator), new Object[0]).body("comments", Matchers.notNullValue(), new Object[0]).body("comments.size()", Matchers.equalTo((Object)0), new Object[0]).body("severity", Matchers.equalTo((Object)severity.name()), new Object[0]).log().ifValidationFails()).given().auth().preemptive().basic(commentator, commentator).contentType("application/json").body((Object)RestCommentUtils.createLineBody(text, file, null, line, lineType, fileType)).post(url, new Object[0]);
    }

    public static Response addDiffMultilineComment(String commentator, CommentThreadDiffAnchorType diffType, @Nullable String fromHash, @Nullable String toHash, String file, int line, DiffSegmentType lineType, JSONObject multilineMarker, JSONObject multilineSpan, String url, Response.StatusType expectedStatus, ResponseSpecification spec, CommentState state) {
        JSONObject anchor = RestCommentUtils.createAnchorBody(file, null, diffType.name());
        anchor.put((Object)"fromHash", (Object)fromHash);
        anchor.put((Object)"toHash", (Object)toHash);
        anchor.put((Object)"multilineMarker", (Object)multilineMarker);
        anchor.put((Object)"multilineSpan", (Object)multilineSpan);
        JSONObject lineBody = RestCommentUtils.createLineBody("Line comment, CONTEXT/TO", file, null, line, lineType.name(), DiffFileType.TO.name(), anchor, state);
        return (Response)((ResponseSpecification)RestAssured.expect().statusCode(expectedStatus.getStatusCode()).spec(spec).log().ifValidationFails()).given().auth().preemptive().basic(commentator, commentator).contentType("application/json").body((Object)lineBody).post(url, new Object[0]);
    }

    public static Response addFileComment(String commentator, String file, String url) {
        return (Response)((ResponseSpecification)RestAssured.expect().spec(RestCommentUtils.createSpecBuilderWithNoReplies(Response.Status.CREATED, null, "A file comment", commentator).build()).log().ifValidationFails()).given().auth().preemptive().basic(commentator, commentator).contentType("application/json").body((Object)RestCommentUtils.createFileBody("A file comment", file, null)).post(url, new Object[0]);
    }

    public static JSONObject createAnchorBody(String path, String srcPath) {
        return RestCommentUtils.createAnchorBody(path, srcPath, "EFFECTIVE");
    }

    public static JSONObject createAnchorBody(String path, String srcPath, String diffType) {
        JSONObject anchor = new JSONObject();
        anchor.put((Object)"path", (Object)path);
        anchor.put((Object)"srcPath", (Object)srcPath);
        anchor.put((Object)"diffType", (Object)diffType);
        return anchor;
    }

    public static JSONObject createBody(String text) {
        JSONObject body = new JSONObject();
        body.put((Object)"text", (Object)text);
        return body;
    }

    public static JSONObject createBodyWithState(String text, CommentState state) {
        JSONObject body = new JSONObject();
        body.put((Object)"text", (Object)text);
        body.put((Object)"state", (Object)state);
        return body;
    }

    public static JSONObject createBodyWithVersion(String text, int version) {
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"version", (Object)version);
        return body;
    }

    public static JSONObject createFileBody(String text, String path, String srcPath) {
        return RestCommentUtils.createFileBody(text, path, srcPath, null);
    }

    public static JSONObject createFileBody(String text, String path, String srcPath, CommentState state) {
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"anchor", (Object)RestCommentUtils.createAnchorBody(path, srcPath));
        body.put((Object)"state", (Object)state);
        return body;
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, DiffSegmentType lineType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, (String)null);
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, DiffSegmentType lineType, String fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, (String)Optional.ofNullable(lineType).map(Enum::name).orElse(null), fileType);
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, DiffSegmentType lineType, DiffFileType fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, (String)Optional.ofNullable(lineType).map(Enum::name).orElse(null), (String)Optional.ofNullable(fileType).map(Enum::name).orElse(null));
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, String lineType, DiffFileType fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, (String)Optional.ofNullable(fileType).map(Enum::name).orElse(null));
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, String lineType, String fileType) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, fileType, RestCommentUtils.createAnchorBody(path, srcPath));
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, String lineType, String fileType, JSONObject anchor) {
        return RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, fileType, anchor, null);
    }

    public static JSONObject createLineBody(String text, String path, String srcPath, int line, String lineType, String fileType, JSONObject anchor, CommentState commentState) {
        anchor.put((Object)"line", (Object)line);
        if (lineType != null) {
            anchor.put((Object)"lineType", (Object)lineType);
        }
        if (fileType != null) {
            anchor.put((Object)"fileType", (Object)fileType);
        }
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"anchor", (Object)anchor);
        body.put((Object)"state", (Object)commentState);
        return body;
    }

    public static JSONObject createMultilineAnchorBody(String path, DiffFileType fileType, int startLine, DiffSegmentType startLineType, int line, DiffSegmentType lineType, @Nullable LineNumberRange srcSpan, @Nullable LineNumberRange dstSpan) {
        JSONObject anchor = new JSONObject();
        anchor.put((Object)"path", (Object)path);
        anchor.put((Object)"srcPath", (Object)path);
        anchor.put((Object)"diffType", (Object)"EFFECTIVE");
        anchor.put((Object)"fileType", (Object)fileType.name());
        anchor.put((Object)"line", (Object)line);
        anchor.put((Object)"lineType", (Object)lineType.name());
        anchor.put((Object)"multilineSpan", (Object)RestCommentUtils.createMultilineCommentSpan(srcSpan, dstSpan));
        anchor.put((Object)"multilineMarker", (Object)RestCommentUtils.createMultilineCommentMarker(startLine, startLineType));
        return anchor;
    }

    public static JSONObject createMultilineBody(String text, JSONObject multilineAnchor, CommentState commentState) {
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"anchor", (Object)multilineAnchor);
        body.put((Object)"state", (Object)commentState);
        return body;
    }

    public static JSONObject createMultilineCommentMarker(int startLine, DiffSegmentType startLineType) {
        JSONObject multilineMarker = new JSONObject();
        multilineMarker.put((Object)"startLine", (Object)startLine);
        multilineMarker.put((Object)"startLineType", (Object)startLineType.name());
        return multilineMarker;
    }

    public static JSONObject createMultilineCommentSpan(int srcSpanStart, int srcSpanEnd, int dstSpanStart, int dstSpanEnd) {
        JSONObject multilineSpan = new JSONObject();
        multilineSpan.put((Object)"srcSpanStart", (Object)srcSpanStart);
        multilineSpan.put((Object)"srcSpanEnd", (Object)srcSpanEnd);
        multilineSpan.put((Object)"dstSpanStart", (Object)dstSpanStart);
        multilineSpan.put((Object)"dstSpanEnd", (Object)dstSpanEnd);
        return multilineSpan;
    }

    public static JSONObject createMultilineCommentSpan(@Nullable LineNumberRange sourceRange, @Nullable LineNumberRange destinationRange) {
        JSONObject multilineSpan = new JSONObject();
        if (sourceRange != null) {
            multilineSpan.put((Object)"srcSpanStart", (Object)sourceRange.minimum());
            multilineSpan.put((Object)"srcSpanEnd", (Object)sourceRange.maximum());
        }
        if (destinationRange != null) {
            multilineSpan.put((Object)"dstSpanStart", (Object)destinationRange.minimum());
            multilineSpan.put((Object)"dstSpanEnd", (Object)destinationRange.maximum());
        }
        return multilineSpan;
    }

    public static JSONObject createReplyBody(String text, long parentId) {
        return RestCommentUtils.createReplyBody(text, parentId, null);
    }

    public static JSONObject createReplyBody(String text, long parentId, CommentState commentState) {
        return RestCommentUtils.createReplyBody(text, parentId, commentState, CommentSeverity.NORMAL);
    }

    public static JSONObject createReplyBody(String text, long parentId, CommentState commentState, CommentSeverity severity) {
        JSONObject parent = new JSONObject();
        parent.put((Object)"id", (Object)parentId);
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"parent", (Object)parent);
        body.put((Object)"state", (Object)commentState);
        body.put((Object)"severity", (Object)severity);
        return body;
    }

    public static JSONObject createResolvedBody(String text, int version) {
        JSONObject body = RestCommentUtils.createBody(text);
        body.put((Object)"version", (Object)version);
        body.put((Object)"state", (Object)CommentState.RESOLVED);
        return body;
    }

    public static ResponseSpecBuilder createSpecBuilder(Response.Status status, MutableLong commentId, String text, String authorName) {
        return new ResponseSpecBuilder().expectStatusCode(status.getStatusCode()).expectBody("text", Matchers.equalTo((Object)text)).expectBody("id", RestTestHelper.captureLongId(commentId)).expectBody("version", Matchers.equalTo((Object)0)).expectBody("createdDate", Matchers.notNullValue()).expectBody("updatedDate", Matchers.notNullValue()).expectBody("author", Matchers.notNullValue()).expectBody("author.name", Matchers.equalTo((Object)authorName)).expectBody("comments", Matchers.notNullValue());
    }

    public static ResponseSpecBuilder createSpecBuilderForMultilineComments(Response.Status status, MutableLong commentId, String text, String authorName) {
        return RestCommentUtils.createSpecBuilderWithNoReplies(status, commentId, text, authorName).expectBody("anchor.multilineMarker", Matchers.notNullValue());
    }

    public static ResponseSpecBuilder createSpecBuilderWithNoReplies(Response.Status status, MutableLong commentId, String text, String authorName) {
        return RestCommentUtils.createSpecBuilder(status, commentId, text, authorName).expectBody("comments.size()", Matchers.equalTo((Object)0));
    }

    public static String getCommitDiscussionCommentsUrl(String projectKey, String repositorySlug, String commitId) {
        return DefaultFuncTestData.getRepositoryRestURL(projectKey, repositorySlug) + "/commits/" + commitId + "/comments";
    }

    public static String getPullRequestCommentsUrl(String projectKey, String repositorySlug, long pullRequestId) {
        return DefaultFuncTestData.getRepositoryRestURL(projectKey, repositorySlug) + "/pull-requests/" + pullRequestId + "/comments";
    }
}

