/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.jiracloud;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.junit.Assert;

public class JiraSiteConfigTestHelper {
    private static final String ENDPOINT = "/jira-site-config";

    public static void assertConfig(Response response) {
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        JsonPath path = JsonPath.from((String)response.asString());
        Assert.assertEquals((Object)"CONNECTED", (Object)path.getString("connectionStatus"));
        Assert.assertFalse((boolean)path.getString("id").isEmpty());
    }

    public static void assertCloudId(String cloudId, Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        Assert.assertEquals((Object)cloudId, (Object)path.getString("cloudId"));
    }

    public static void assertCloudIdFetchError(Response response) {
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusCode());
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> errors = RestTestHelper.extractValues(path, "errors");
        JSONObject error = errors.get(0);
        Assert.assertEquals((Object)"Unable to fetch Cloud ID for the given URL", (Object)error.getString("message"));
        Assert.assertEquals((Object)"com.atlassian.stash.internal.jira.cloud.config.exception.JiraSiteConfigException", (Object)error.getString("exceptionName"));
    }

    public static void assertConfigList(List<Integer> jiraSiteIds, Response response) {
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        List<Integer> extractedJiraSiteIds = JiraSiteConfigTestHelper.extractJiraSiteIds(response);
        Assert.assertTrue((extractedJiraSiteIds.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)extractedJiraSiteIds.containsAll(jiraSiteIds));
    }

    public static void assertInvalidOauthCredentialsError(Response response) {
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusCode());
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> errors = RestTestHelper.extractValues(path, "errors");
        JSONObject error = errors.get(0);
        Assert.assertEquals((Object)"Invalid OAuth credentials", (Object)error.getString("message"));
        Assert.assertEquals((Object)"com.atlassian.stash.internal.jira.cloud.config.exception.InvalidOauthCredentialException", (Object)error.getString("exceptionName"));
    }

    public static void assertUpdatedConfig(String name, Response response) {
        JiraSiteConfigTestHelper.assertConfig(response);
        JsonPath path = JsonPath.from((String)response.asString());
        Assert.assertEquals((Object)name, (Object)path.getString("name"));
    }

    public static Response createJiraSiteConfig(String name, String clientId, String clientSecret, String jiraSiteUrl) {
        return JiraSiteConfigTestHelper.createJiraSiteConfig(new BasicAuth(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()), name, clientId, clientSecret, jiraSiteUrl);
    }

    public static Response createJiraSiteConfig(Object credentials, String name, String clientId, String clientSecret, String jiraSiteUrl) {
        return (Response)JiraSiteConfigTestHelper.getAuthenticatedRequest(credentials).body(JiraSiteConfigTestHelper.getRequestPayload(name, clientId, clientSecret, jiraSiteUrl)).when().post(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT, new Object[0]);
    }

    public static Response createJiraSiteConfigNonAdmin(String name, String clientId, String clientSecret, String jiraSiteUrl) {
        return JiraSiteConfigTestHelper.createJiraSiteConfig(new BasicAuth(DefaultFuncTestData.getRegularUser(), DefaultFuncTestData.getRegularUserPassword()), name, clientId, clientSecret, jiraSiteUrl);
    }

    public static void deleteAllJiraSites() {
        JiraSiteConfigTestHelper.extractJiraSiteIds(JiraSiteConfigTestHelper.getAllJiraSiteConfig()).stream().forEach(id -> JiraSiteConfigTestHelper.deleteJiraSiteConfig(id));
    }

    public static int extractJiraSiteId(Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        return path.getInt("id");
    }

    public static List<Integer> extractJiraSiteIds(Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> jiraSiteConfigList = RestTestHelper.extractValues(path, "values");
        List<Integer> extractedJiraSiteIds = jiraSiteConfigList.stream().map(f -> f.getInt("id")).collect(Collectors.toList());
        return extractedJiraSiteIds;
    }

    public static List<String> extractNames(Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> jiraSiteConfigList = RestTestHelper.extractValues(path, "values");
        return jiraSiteConfigList.stream().map(f -> f.getString("name")).collect(Collectors.toList());
    }

    public static Response deleteJiraSiteConfig(int id) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + "/jira-site-config/{id}", new Object[]{id});
    }

    public static Response getAllJiraSiteConfig() {
        return JiraSiteConfigTestHelper.getAllJiraSiteConfig(new BasicAuth(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()));
    }

    public static Response getAllJiraSiteConfig(Object credentials) {
        return (Response)JiraSiteConfigTestHelper.getAuthenticatedRequest(credentials).when().get(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT, new Object[0]);
    }

    public static Response getJiraSiteConfig(int id) {
        return JiraSiteConfigTestHelper.getJiraSiteConfig(new BasicAuth(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()), id);
    }

    public static Response getJiraSiteConfig(Object credentials, int id) {
        return (Response)JiraSiteConfigTestHelper.getAuthenticatedRequest(credentials).when().get(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + "/jira-site-config/{id}", new Object[]{id});
    }

    public static Response refreshPermissions(int id) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + "/jira-site-config/{id}/refresh-permissions", new Object[]{id});
    }

    public static Response updateJiraSiteConfig(int id, String clientId, String clientSecret, String name, String url) {
        return JiraSiteConfigTestHelper.updateJiraSiteConfig(new BasicAuth(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()), id, clientId, clientSecret, name, url);
    }

    public static Response updateJiraSiteConfig(Object credentials, int id, String clientId, String clientSecret, String name, String url) {
        return (Response)JiraSiteConfigTestHelper.getAuthenticatedRequest(credentials).body(JiraSiteConfigTestHelper.getRequestPayload(name, clientId, clientSecret, url)).when().put(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + "/jira-site-config/{id}", new Object[]{id});
    }

    public static Response invokeDeleteRequest(int id) {
        return (Response)JiraSiteConfigTestHelper.getAuthenticatedRequest(new BasicAuth(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword())).when().delete(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + "/jira-site-config/{id}", new Object[]{id});
    }

    public static Response invokeDeleteRequest(Object credentials, int id) {
        return (Response)JiraSiteConfigTestHelper.getAuthenticatedRequest(credentials).when().delete(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + "/jira-site-config/{id}", new Object[]{id});
    }

    private static RequestSpecification getAuthenticatedRequest(Object credentials) {
        RequestSpecification request = RestAssured.given().contentType("application/json").accept("application/json");
        if (credentials instanceof Header) {
            request.header((Header)credentials);
        } else if (credentials instanceof Map) {
            request.cookies((Map)credentials);
        } else if (credentials instanceof BasicAuth) {
            BasicAuth basicAuth = (BasicAuth)credentials;
            request.auth().preemptive().basic(basicAuth.username, basicAuth.password);
        }
        return request;
    }

    private static String getRequestPayload(String name, String clientId, String clientSecret, String jiraSiteUrl) {
        JSONObject requestParams = new JSONObject();
        requestParams.put((Object)"name", (Object)name);
        requestParams.put((Object)"clientId", (Object)clientId);
        requestParams.put((Object)"clientSecret", (Object)clientSecret);
        requestParams.put((Object)"url", (Object)jiraSiteUrl);
        return requestParams.toString();
    }

    private static String getJiraSiteConfigUrl() {
        return DefaultFuncTestData.getRestURL("jira-dev", "latest");
    }

    public static class BasicAuth {
        private final String password;
        private final String username;

        public BasicAuth(String password, String username) {
            this.password = password;
            this.username = username;
        }
    }
}

