/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.filters;

import com.atlassian.bitbucket.test.annotations.RollingUpgradeIncompatible;
import com.atlassian.bitbucket.test.filters.AnnotationBasedFilter;
import com.atlassian.bitbucket.test.filters.NodeVersionResolver;
import com.atlassian.bitbucket.util.Version;
import org.junit.runner.Description;
import org.junit.runners.model.TestClass;

public class RollingUpgradeIncompatibilityFilter
extends AnnotationBasedFilter {
    private final NodeVersionResolver nodeVersionResolver = new NodeVersionResolver();

    public RollingUpgradeIncompatibilityFilter(TestClass testClass) {
        super(testClass);
    }

    public boolean shouldRun(Description description) {
        RollingUpgradeIncompatible annotation = this.getAnnotation(RollingUpgradeIncompatible.class, description);
        if (annotation == null) {
            return true;
        }
        if (this.nodeVersionResolver.isMixedMode()) {
            Version testVersion = new Version(annotation.beforeVersion());
            return this.nodeVersionResolver.getLowerVersion().map(Version::new).map(v -> v.compareTo(testVersion) >= 0).orElse(true);
        }
        return true;
    }

    public String describe() {
        return String.format("Detects tests marked \"%s\" and filters them out based on the test's version and cluster versions", RollingUpgradeIncompatible.class.getSimpleName());
    }
}

