/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.bitbucket.test.audit.AuditVerifier;
import com.atlassian.bitbucket.test.audit.VerifyAudited;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class AuditVerificationRule
implements TestRule {
    private final List<AuditVerifier> auditVerifiers;

    public AuditVerificationRule(AuditVerifier ... auditVerifiers) {
        this.auditVerifiers = ImmutableList.copyOf((Object[])auditVerifiers);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                VerifyAudited annotation = (VerifyAudited)description.getAnnotation(VerifyAudited.class);
                if (annotation != null) {
                    AuditVerificationRule.this.auditVerifiers.forEach(AuditVerifier::startRecording);
                }
                base.evaluate();
                if (annotation != null) {
                    AuditVerificationRule.this.auditVerifiers.forEach(verifier -> verifier.verify(annotation));
                }
            }
        };
    }
}

