/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONStringer;

public class UserNotificationSettingsTestHelper {
    public static final String SEND_MODE_BATCHED = "BATCHED";
    public static final String SEND_MODE_IMMEDIATE = "IMMEDIATE";

    public static JSONObject createUserSettingsRestBody(String pullRequestSendMode, String repositorySendMode) {
        JSONObject mailObject = new JSONObject();
        if (pullRequestSendMode != null) {
            mailObject.put((Object)"pullRequestNotifications", (Object)UserNotificationSettingsTestHelper.createNotificationSettings(pullRequestSendMode));
        }
        if (repositorySendMode != null) {
            mailObject.put((Object)"repositoryNotifications", (Object)UserNotificationSettingsTestHelper.createNotificationSettings(repositorySendMode));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"email", (Object)mailObject);
        return jsonObject;
    }

    public static void updateLegacySettings(String user, String sendMode) {
        UserNotificationSettingsTestHelper.updateLegacySettings(user, user, sendMode);
    }

    public static void updateLegacySettings(String user, String password, String sendMode) {
        String jsonBody = new JSONStringer().object().key("sendMode").value((Object)sendMode).endObject().toString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).body(jsonBody).when().put(DefaultFuncTestData.getRestURL("notification", "latest") + "/settings", new Object[0])).then()).statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
    }

    public static void updateSettings(String user, String password, String pullRequestSendMode, String repositorySendMode) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).body((Object)UserNotificationSettingsTestHelper.createUserSettingsRestBody(pullRequestSendMode, repositorySendMode)).when().put(DefaultFuncTestData.getRestURL("notification", "latest") + "/settings", new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.NO_CONTENT.getStatusCode());
    }

    private static JSONObject createNotificationSettings(String sendMode) {
        JSONObject settings = new JSONObject();
        settings.put((Object)"sendMode", (Object)sendMode);
        return settings;
    }
}

