/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Ignore;

@Ignore
public class SshKeyTestHelper {
    public static Response addProjectKey(String projectKey, String keyText) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").body((Object)SshKeyTestHelper.createProjectSshKeyBody(keyText, projectKey)).when().post(DefaultFuncTestData.getProjectRestURL("keys", "latest", projectKey) + "/ssh", new Object[0]);
        Assert.assertThat((String)"Expected 2xx status code when creating a project ssh key", (Object)response.getStatusCode(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(300))));
        return response;
    }

    public static Response addSshKey(String sshKeyUsername, String keyText) {
        return SshKeyTestHelper.addSshKey(sshKeyUsername, keyText, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static Response addSshKey(String sshKeyUsername, String keyText, String loginUsername, String loginPassword) {
        Response response = (Response)RestAssured.given().queryParam("user", new Object[]{sshKeyUsername}).auth().preemptive().basic(loginUsername, loginPassword).contentType("application/json;charset=UTF-8").body(SshKeyTestHelper.createSshKeyBody(keyText).toString()).when().post(SshKeyTestHelper.getSshKeysUrl(), new Object[0]);
        Assert.assertThat((String)"Expected 2xx status code when creating an ssh key", (Object)response.getStatusCode(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(300))));
        return response;
    }

    public static Optional<Integer> getSshKeyTypeMinLength(String algorithm) {
        return Optional.ofNullable((Integer)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).log().ifValidationFails()).accept("application/json").contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SshKeyTestHelper.getSshKeySettingsUrl(), new Object[0])).then()).extract().path("keyTypeRestrictions.find{it.algorithm == '" + algorithm + "'}.minKeyLength", new String[0]));
    }

    public static Response setGlobalExpiry(Integer expiryDays) {
        if (expiryDays != null && expiryDays < 1) {
            return (Response)((RequestSpecification)RestAssured.given().log().ifValidationFails()).queryParam("value", new Object[]{expiryDays}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DefaultFuncTestData.getBaseURL() + "/rest/system-ssh/latest/keys/maxExpiryDays", new Object[0]);
        }
        return (Response)((RequestSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).log().ifValidationFails()).accept("application/json").contentType("application/json").body((Object)SshKeyTestHelper.createSshKeyGlobalSettingsBody(expiryDays, null)).expect().statusCode(Response.Status.OK.getStatusCode()).when().put(SshKeyTestHelper.getSshKeySettingsUrl(), new Object[0]);
    }

    public static Response setSshKeyTypeAllowed(String keyType, boolean enabled, int minKeyLength) {
        ArrayList<Map<String, Object>> keyTypeRestrictions = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> restrictions = new HashMap<String, Object>();
        if (enabled) {
            restrictions.put("minKeyLength", minKeyLength);
        }
        restrictions.put("allowed", enabled);
        restrictions.put("algorithm", keyType);
        keyTypeRestrictions.add(restrictions);
        return (Response)((RequestSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).log().ifValidationFails()).accept("application/json").contentType("application/json").body((Object)SshKeyTestHelper.createSshKeyGlobalSettingsBody(null, keyTypeRestrictions)).expect().statusCode(Response.Status.OK.getStatusCode()).when().put(SshKeyTestHelper.getSshKeySettingsUrl(), new Object[0]);
    }

    public static void deleteAllSshKeys(String username) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).queryParam("user", new Object[]{username}).when().delete(SshKeyTestHelper.getSshKeysUrl(), new Object[0]);
        int status = response.getStatusCode();
        Assert.assertThat((String)("The keys for user " + username + " could not be deleted\n" + SshKeyTestHelper.dumpResponse(response)), (Object)status, (Matcher)Matchers.either((Matcher)IsEqual.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode())).or(IsEqual.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode())));
    }

    public static String getSshKeysUrl() {
        return DefaultFuncTestData.getRestURL("ssh", "latest") + "/keys";
    }

    public static String getSshKeySettingsUrl() {
        return DefaultFuncTestData.getRestURL("ssh", "latest") + "/admin";
    }

    public static Response removeSshKey(Integer keyId) {
        return SshKeyTestHelper.removeSshKey(keyId, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static Response removeSshKey(Integer keyId, String loginUsername, String loginPassword) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(loginUsername, loginPassword).contentType("application/json;charset=UTF-8").when().delete(SshKeyTestHelper.getSshKeysUrl() + "/{id}", new Object[]{keyId});
        Assert.assertThat((String)"Expected 2xx status code when deleting ssh key", (Object)response.getStatusCode(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(300))));
        return response;
    }

    public static Response removeSshKeys(String sshKeyUsername) {
        Response response = (Response)RestAssured.given().queryParam("user", new Object[]{sshKeyUsername}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().delete(SshKeyTestHelper.getSshKeysUrl(), new Object[0]);
        Assert.assertThat((String)"Expected 2xx status code when deleting all ssh keys", (Object)response.getStatusCode(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(300))));
        return response;
    }

    private static JSONObject createProjectSshKeyBody(String keyText, String projectKey) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"permission", (Object)"PROJECT_WRITE");
        JSONObject keyObject = new JSONObject();
        keyObject.put((Object)"text", (Object)keyText);
        bodyObject.put((Object)"key", (Object)keyObject);
        JSONObject projectKeyObject = new JSONObject();
        projectKeyObject.put((Object)"key", (Object)projectKey);
        bodyObject.put((Object)"project", (Object)projectKeyObject);
        return bodyObject;
    }

    private static JSONObject createSshKeyBody(String keyText) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"text", (Object)keyText);
        return bodyObject;
    }

    private static JSONObject createSshKeyGlobalSettingsBody(Integer expiryDays, List<Map<String, Object>> keyTypeRestrictions) {
        JSONObject bodyObject = new JSONObject();
        if (expiryDays != null) {
            bodyObject.put((Object)"maxExpiryDays", (Object)expiryDays);
        }
        if (keyTypeRestrictions == null) {
            bodyObject.put((Object)"keyTypeRestrictions", (Object)"[]");
        } else {
            bodyObject.put((Object)"keyTypeRestrictions", keyTypeRestrictions);
        }
        return bodyObject;
    }

    private static String dumpResponse(Response response) {
        return "------------------\nResponse from the server:\n" + response.getStatusLine() + "\n" + response.getBody().asString() + "\n------------------\n";
    }
}

