/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.ClusterUtils;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import org.hamcrest.Matchers;

public class SecretsTestHelper {
    private SecretsTestHelper() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static void verifySecretValue(ValueSource valueSource, String expectedValue) {
        ClusterUtils.executeOnEachNode(SecretsTestHelper.getRestUrl(valueSource.path), url -> {
            RestAssured.expect().statusCode(200).body("value", Matchers.equalTo((Object)expectedValue), new Object[0]).when().get(url, new Object[0]);
            return null;
        });
    }

    private static String getRestUrl(String path) {
        return DefaultFuncTestData.getRestURL("secrets-tests", "latest") + "/configuration-secret/" + path;
    }

    public static enum ValueSource {
        CONFIG_FILE("config-file-value"),
        ENVIRONMENT("environment-value");

        private final String path;

        private ValueSource(String path) {
            this.path = path;
        }
    }
}

