/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningAllowlistRule;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningRule;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ResponsePage;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public class SecretScanningTestHelper {
    private static final String ID = "id";
    private static final String LINE_REGEX = "lineRegex";
    private static final String NAME = "name";
    private static final String PATH_REGEX = "pathRegex";
    private static final String SECRET_SCANNING_PATH = "/secret-scanning";
    private final String allowListUrl;
    private final String baseUrl;
    private final String projectKey;
    private final String repoSlug;
    private final String ruleUrl;

    public SecretScanningTestHelper() {
        this(null, null);
    }

    public SecretScanningTestHelper(String projectKey) {
        this(projectKey, null);
    }

    public SecretScanningTestHelper(@Nullable String projectKey, @Nullable String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
        this.baseUrl = repoSlug == null && projectKey == null ? DefaultFuncTestData.getRestURL() + SECRET_SCANNING_PATH : (repoSlug == null ? DefaultFuncTestData.getProjectRestURL(projectKey) + SECRET_SCANNING_PATH : DefaultFuncTestData.getRepositoryRestURL(projectKey, repoSlug) + SECRET_SCANNING_PATH);
        this.ruleUrl = this.baseUrl + "/rules";
        this.allowListUrl = this.baseUrl + "/allowlist";
    }

    public static Map<String, Object> rule(@Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        return SecretScanningTestHelper.rule(null, name, lineRegex, pathRegex);
    }

    public static Map<String, Object> rule(@Nullable Long id, @Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put(ID, id);
        request.put(NAME, name);
        request.put(LINE_REGEX, lineRegex);
        request.put(PATH_REGEX, pathRegex);
        return request;
    }

    public static Map<String, Object> secretLocation(@Nonnull String commitId, @Nullable Integer line, @Nonnull String path, @Nonnull String ruleName) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("commitId", commitId);
        request.put("line", line);
        request.put("path", path);
        request.put("ruleName", ruleName);
        return request;
    }

    public RestSecretScanningAllowlistRule createAllowlist(@Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        return (RestSecretScanningAllowlistRule)this.createAllowlist(name, lineRegex, pathRegex, DefaultFuncTestData.getAdminUser(), Response.Status.OK).as(RestSecretScanningAllowlistRule.class);
    }

    public Response createAllowlist(@Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex, @Nonnull String user, @Nonnull Response.Status status) {
        return (Response)((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json").when().body(SecretScanningTestHelper.rule(name, lineRegex, pathRegex)).post(this.allowListUrl, new Object[0]);
    }

    public RestSecretScanningRule createRule(@Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        return (RestSecretScanningRule)this.createRule(name, lineRegex, pathRegex, DefaultFuncTestData.getAdminUser(), Response.Status.OK).as(RestSecretScanningRule.class);
    }

    public Response createRule(@Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex, Object credentials, Response.Status status) {
        return (Response)this.getAuthenticatedRequest(credentials, status).when().body(SecretScanningTestHelper.rule(name, lineRegex, pathRegex)).post(this.ruleUrl, new Object[0]);
    }

    public void createSecret(@Nonnull String user, @Nonnull String commitId, @Nullable Integer line, @Nonnull String path, @Nonnull String ruleName) {
        ((ResponseSpecification)RestAssured.expect().statusCode(204).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json").when().body(SecretScanningTestHelper.secretLocation(commitId, line, path, ruleName)).post(this.getCreateSecretUrl(this.projectKey, this.repoSlug), new Object[0]);
    }

    public void deleteAllowlist() {
        PageUtils.toStream(pageRequest -> {
            ResponsePage<RestSecretScanningAllowlistRule> search = this.searchAllowlist(null, null, pageRequest.getStart(), pageRequest.getLimit());
            return PageUtils.createPage(search.getValues(), (PageRequest)pageRequest);
        }, (int)100).forEach(allowlistRule -> this.deleteAllowlistRule(allowlistRule.getId()));
    }

    public void deleteAllowlistRule(long id) {
        this.deleteAllowlistRule(id, DefaultFuncTestData.getAdminUser(), Response.Status.NO_CONTENT);
    }

    public Response deleteAllowlistRule(long id, @Nonnull String user, @Nonnull Response.Status status) {
        return (Response)((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json").when().delete(this.allowListUrl + "/" + id, new Object[0]);
    }

    public void deleteCustomRules() {
        PageUtils.toStream(pageRequest -> {
            ResponsePage<RestSecretScanningRule> search = this.search(null, null, pageRequest.getStart(), pageRequest.getLimit());
            return PageUtils.createPage(search.getValues(), (PageRequest)pageRequest);
        }, (int)100).forEach(rule -> {
            if (rule.getId() > 99L) {
                this.deleteRule(rule.getId());
            }
        });
    }

    public void deleteRule(Long id) {
        this.deleteRule(id, DefaultFuncTestData.getAdminUser(), Response.Status.NO_CONTENT);
    }

    public Response deleteRule(Long id, Object credentials, Response.Status status) {
        return (Response)this.getAuthenticatedRequest(credentials, status).when().delete(this.ruleUrl + "/" + id, new Object[0]);
    }

    public RestSecretScanningAllowlistRule getAllowlistRule(Long id) {
        return (RestSecretScanningAllowlistRule)this.getAllowlistRule(id, DefaultFuncTestData.getAdminUser(), Response.Status.OK).as(RestSecretScanningAllowlistRule.class);
    }

    public Response getAllowlistRule(long id, @Nonnull String user, @Nonnull Response.Status status) {
        return (Response)((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json").when().get(this.allowListUrl + "/" + id, new Object[0]);
    }

    public RestSecretScanningRule getRule(Long id) {
        return (RestSecretScanningRule)this.getRule(id, DefaultFuncTestData.getAdminUser(), Response.Status.OK).as(RestSecretScanningRule.class);
    }

    public Response getRule(Long id, String user, Response.Status status) {
        return (Response)((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json").when().get(this.ruleUrl + "/" + id, new Object[0]);
    }

    public ResponsePage<RestSecretScanningRule> search(String filter, String order, Integer start, Integer limit) {
        return new ResponsePage<RestSecretScanningRule>(this.search(filter, order, start, limit, DefaultFuncTestData.getAdminUser(), Response.Status.OK).getBody().jsonPath(), value -> new RestSecretScanningRule((Map)value));
    }

    public Response search(String filter, String order, Integer start, Integer limit, String user, Response.Status status) {
        RequestSpecification spec = ((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json");
        if (filter != null) {
            spec.queryParam("filter", new Object[]{filter});
        }
        if (order != null) {
            spec.queryParam("order", new Object[]{order});
        }
        if (start != null) {
            spec.queryParam("start", new Object[]{start});
        }
        if (limit != null) {
            spec.queryParam("limit", new Object[]{limit});
        }
        return (Response)spec.when().get(this.ruleUrl, new Object[0]);
    }

    public ResponsePage<RestSecretScanningAllowlistRule> searchAllowlist(@Nullable String filter, @Nullable String order, @Nullable Integer start, @Nullable Integer limit) {
        return new ResponsePage<RestSecretScanningAllowlistRule>(this.searchAllowlist(filter, order, start, limit, DefaultFuncTestData.getAdminUser(), Response.Status.OK).getBody().jsonPath(), value -> new RestSecretScanningAllowlistRule((Map)value));
    }

    public Response searchAllowlist(@Nullable String filter, @Nullable String order, @Nullable Integer start, @Nullable Integer limit, @Nonnull String user, @Nonnull Response.Status status) {
        RequestSpecification spec = ((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json");
        if (filter != null) {
            spec.queryParam("filter", new Object[]{filter});
        }
        if (order != null) {
            spec.queryParam("order", new Object[]{order});
        }
        if (start != null) {
            spec.queryParam("start", new Object[]{start});
        }
        if (limit != null) {
            spec.queryParam("limit", new Object[]{limit});
        }
        return (Response)spec.when().get(this.allowListUrl, new Object[0]);
    }

    public RestSecretScanningAllowlistRule updateAllowlistRule(@Nullable Long id, @Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        return (RestSecretScanningAllowlistRule)this.updateAllowlistRule(id, name, lineRegex, pathRegex, DefaultFuncTestData.getAdminUser(), Response.Status.OK).as(RestSecretScanningAllowlistRule.class);
    }

    public Response updateAllowlistRule(@Nullable Long id, @Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex, @Nonnull String user, @Nonnull Response.Status status) {
        return (Response)((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(user, user).contentType("application/json").when().body(SecretScanningTestHelper.rule(name, lineRegex, pathRegex)).put(this.allowListUrl + "/" + id, new Object[0]);
    }

    public RestSecretScanningRule updateRule(@Nullable Long id, @Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        return (RestSecretScanningRule)this.updateRule(id, name, lineRegex, pathRegex, DefaultFuncTestData.getAdminUser(), Response.Status.OK).as(RestSecretScanningRule.class);
    }

    public Response updateRule(@Nullable Long id, @Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex, Object credentials, Response.Status status) {
        return (Response)this.getAuthenticatedRequest(credentials, status).when().body(SecretScanningTestHelper.rule(name, lineRegex, pathRegex)).put(this.ruleUrl + "/" + id, new Object[0]);
    }

    private RequestSpecification getAuthenticatedRequest(Object credentials, Response.Status status) {
        RequestSpecification requestSpecification = ((ResponseSpecification)RestAssured.expect().statusCode(status.getStatusCode()).log().ifValidationFails()).given().contentType("application/json");
        if (credentials instanceof Header) {
            requestSpecification.header((Header)credentials);
        } else if (credentials instanceof Map) {
            requestSpecification.cookies((Map)credentials);
        } else {
            String user = (String)credentials;
            requestSpecification.auth().preemptive().basic(user, user);
        }
        return requestSpecification;
    }

    private String getCreateSecretUrl(String projectKey, String repoSlug) {
        return DefaultFuncTestData.getBaseURL() + "/rest/browser-tests/latest/projects/" + projectKey + "/repos/" + repoSlug + "/secretscan";
    }
}

