/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class RepositoryShortcutTestHelper {
    public static int createShortcut(String project, String repository, String label, String url) {
        return (Integer)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)RepositoryShortcutTestHelper.createRepositoryShortcutBody(label, url)).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RepositoryShortcutTestHelper.getRepositoryShortcutsUrl(project, repository), new Object[0])).then()).extract().path("id", new String[0]);
    }

    public static void deleteAllShortcuts(String project, String repository) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(RepositoryShortcutTestHelper.getRepositoryShortcutsUrl(project, repository), new Object[0]);
        List values = (List)response.jsonPath().get("values");
        values.stream().map(shortcut -> (Integer)shortcut.get("id")).forEach(id -> RepositoryShortcutTestHelper.deleteShortcut(project, repository, id));
    }

    public static void deleteShortcut(String project, String repository, int id) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(RepositoryShortcutTestHelper.getRepositoryShortcutsUrl(project, repository, id), new Object[0]);
    }

    public static void updateShortcut(String project, String repository, int id, String label, String url) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)RepositoryShortcutTestHelper.createRepositoryShortcutBody(label, url)).expect().statusCode(Response.Status.OK.getStatusCode()).when().put(RepositoryShortcutTestHelper.getRepositoryShortcutsUrl(project, repository, id), new Object[0]);
    }

    private static JSONObject createRepositoryShortcutBody(String label, String url) {
        JSONObject body = new JSONObject();
        body.put((Object)"label", (Object)label);
        body.put((Object)"url", (Object)url);
        return body;
    }

    private static String getRepositoryShortcutsUrl(String project, String repo) {
        return DefaultFuncTestData.getRepositoryRestURL("repository-shortcuts", "latest", project, repo) + "/shortcuts";
    }

    private static String getRepositoryShortcutsUrl(String project, String repo, int id) {
        return RepositoryShortcutTestHelper.getRepositoryShortcutsUrl(project, repo) + "/" + id;
    }
}

