/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import javax.ws.rs.core.Response;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;

public final class MaintenanceModeHelper {
    public static final String LOCK_URL = DefaultFuncTestData.getBaseURL() + "/mvc/maintenance/lock";
    private static final String ADMIN_USER = DefaultFuncTestData.getAdminUser();
    private static final String ADMIN_PASSWORD = DefaultFuncTestData.getAdminPassword();

    public static void assertStashLocked(boolean locked) {
        Response.Status expectedStatus = locked ? Response.Status.SERVICE_UNAVAILABLE : Response.Status.OK;
        RestAssured.given().auth().preemptive().basic(ADMIN_USER, ADMIN_PASSWORD).expect().statusCode(expectedStatus.getStatusCode()).when().get(DefaultFuncTestData.getBaseURL(), new Object[0]);
    }

    public static String lockStash() {
        Response lockResponse = (Response)RestAssured.given().auth().preemptive().basic(ADMIN_USER, ADMIN_PASSWORD).contentType("application/json").body("").expect().statusCode(Response.Status.ACCEPTED.getStatusCode()).body("owner.name", IsEqual.equalTo((Object)"admin"), new Object[0]).body("unlockToken", Matchers.notNullValue(), new Object[0]).when().post(LOCK_URL, new Object[0]);
        return (String)lockResponse.getBody().jsonPath().get("unlockToken");
    }

    public static void unlockStash(String unlockToken) {
        MaintenanceModeHelper.unlockWithUserExpectingStatus(unlockToken, ADMIN_USER, ADMIN_PASSWORD, Response.Status.OK);
    }

    public static void unlockStashIgnoreStatus(String unlockToken) {
        MaintenanceModeHelper.unlockWithUserExpectingStatus(unlockToken, ADMIN_USER, ADMIN_PASSWORD, null);
    }

    public static void unlockWithUserExpectingStatus(String unlockToken, String user, String password, Response.Status statusExpectation) {
        RequestSpecification unlockSpecification = RestAssured.given().auth().preemptive().basic(user, password).header("X-Atlassian-Maintenance-Token", (Object)unlockToken, new Object[0]).param("token", new Object[]{unlockToken});
        if (statusExpectation != null) {
            unlockSpecification.expect().statusCode(statusExpectation.getStatusCode());
        }
        unlockSpecification.when().delete(LOCK_URL, new Object[0]);
    }
}

