/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.UserTestHelper;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LicenseTestHelper {
    public static final int DEFAULT_LICENSED_USER_COUNT = 2;
    public static final String FIVE_HUNDRED_USER_LICENSE = "AAABtQ0ODAoPeNqVkstu2zAQRff8CgLdGaAsK6mTGBDQRGLTFLFk2HKAvhYUPbZYS6TAh1L/fWlLbtMUXR\nQgNzNzZ85c8k1ROTxnGk+ucXg5u5jOJlN8Py9wFEYTlLmmBJ1v1wa0id+GIUqUtIzbjDUQl1C5\npq00HMw7ZmtmjGAy4KpBxjJTBY+CgzRQHFo41af0iT7mC7pEC6d5xQykzELsJ4UkvPEH/VsxZO\niPVujDSbaYROGHMw+dM1H/D9CL1ivQHeiHNL6jV5Rcpp8jMs0/XpH7i5vrQegHsgSkBR1b7QCt\nXGm4Fq0VSvaR0WiU5QV5ny/JYpmn66R4yDOyXlGfiBMNnniDywO2FeABA1PJ1QY0brX6DtziL5\nW17dfZeLxTwR/447pXEOgV3wKcKiyVxRthrBals+A7C4OtwtwZqxr/XgHypnhmyST/27h+MW+d\n6ODXCsmS3hY0JXefjth8r3ilOrMXZ/u9SWu5l+pZohXNYn/J8VPkesekMOxkx+2ZHJ3W9qHXrz\nxs8+QZj4IIpfDbzQKMxUMF3irvTu12QuINdFCr1msQ7Vjt+mFbVhtAPwGEsPITMCwCFHgRkQAn\nC3S2RLn9nEfUK6nzjS+sAhRVEz/r08UwhQ5ibG8NpdLgxhwt1Q==X02l1";
    public static final String FIVE_USER_LICENSE = "AAABmQ0ODAoPeNp9Ul1v2jAUfc+vsLQ3JAeStRKrFGk0CR0bIYiGStO2h4u5bTyCjewbNv79TG\nIkWlWT8nTPvSfnwx+qumUFGBaN2Si+u71xH3soKhaP4ihItSIQtIA9JmKnRa2PdicD\nS2DrcC4FKovV6YDdQloWRb5KZ5O5XyhAKkIFSmD+9yDNKQPCZBl9ufDmbqO5Jn5Ec0\nQzy5L7cjrmT/N4ytPxzQOffau+elLHASk6XpOQadFPS/MCSlogqVUyoQaslaA8uGyN\nqMFi9/t4FMV89JFHnzyaGuzO3ke9yTf6B4PBoqz4tFzx5arM1mk1Kxd8/Zg7IOkIcc\ns2J0Y1Ms/AciX0Fg07GP0bBbEfNdHh591w+KJDuCgOhd4Pm/6CY3/xK2SZZkoT20pL\nRm5aQscsLSPNRGtJ79HY8GLnqjJC63LygBvKI/ahOZnpKp9Uecbvv581X3Xg9boS1m\nqn9B8V/D+hRbvfoCmf19apSG79ND9C0/Z1PENjMfCmntzSeRi/ltu/hLPez6+yuDQI\nhhSazlTwD/wQ7V8wLAIUFcSiFH+Hf4T2qDJcog1dwqEFzkUCFFoGwTK/BLK0zzyZBW\n2RdVhCrQQYX02jn";
    public static final String FORGED_LICENSE = "AAABxg0ODAoPeNp9Ul1vmzAUfedXWNpbJEig7UskpCVA1EgNREA6rV0fHOemeCE2sq+z5d/PASO10\n7TXe+49Ph/+8g0OpGBIwpBE0fwhnIcRSbKqJtEsuvMSKZAyzOkZYnaSrJEXfeKeRqqb4IkzEBrqa\nwf9QlJsNlmZrBdPbmFDuUAQVDDIfndcXVOKEG/Dx5E3sxvtR+IK1AXUOo2X9y8rf1Zlaz8ply/+c\n5E/OFLLQROwvCpGZcBNC/VOBdcUuRTxAluqNadiPAHNFO96rAaNpB2Uk6NUBBsgFaDpyMoIRm64J\nvJIqtupI9gaxRqqoddvgwn92Z0f3js0UdC/+2/UpfRXAJPJJC9qf1WU/rYs0l1Sr4vc31WZBeKe0\nPayv/bqHAPJBJMHUKRT8ifYyl4bxO7HfDp9lwEdLQdMnqfOnw/DxVtAUkmERHLgGhXfGwTLzDVBS\nZjRKM+gdDDa+dD5loNSY8Z2yC8wpG5lJmW2qLPUX36/aX41ghqrViBnvXij7cOe024b3YmTkL+E9\n/+0cnPegyqOO3ut48hNswttzdDtkbYaPGfw2S7dhtFn6cO36qCTXEn8+imbsVGqUIDqTXp/ADeGC\n5UwLQIUCaHYroKDNLjcqp53QCnxrY1Qw74CFQCAgP0gYL9McWYqbRg/ySCqfo3HcQ==X02lp";
    public static final String HUNDRED_USER_LICENSE = "AAABow0ODAoPeNp1ksuO2jAUhvd5iiN1h+SQAC0tUhYziUsZlQSRsOht4YQDuE3syD5hytvXQzIXz\nagLb871+//jd2ut4K6rIZxCMFvMwsU0hOW6gEkwCby0a0o02WFn0dgoDAIv1opERaloMKpsVxpxR\npKeJWFP/ldZobJYXFq8FhQ8L1bp8m32KbPpTHUSFhNBGD2sZMGchVPvf5OGOP/bSnO5Nm3CSfDlE\nYuvhaxfcuVozmhWSXTL55zNku8T9iG7m7Pl9NPHActNETEqQhOR6dDLu9JWRrYkteojo9EozQr2O\nduyzTZLdnGxylK2y7lLRLFBh7GH8gJ0QhgAgatK79FAa/RvrAh+nIjan4vx+Kh9QbWwVgrlV7oZ1\n30Hw77jlw+JBqUJ9tKSkWVH6CZLC6Sh6izpxt3C95xSx6yEqt660QtzfsgzPkmIt/ym4Am7/faA/\ncKjAdmZtFN/lL5XXs7TyD323h08M0ehpBVXO24eyb2rbBd6fbgEn80r0BIM8uCgDRhX7AKNJCiNv\nnefCsjVSHX0+FnUXb/kIGqL3j8XnuGlMCsCEy+qBwzk4zefPyhmS1DIrx8BkmECFA1RqBGUyBFVw\n2F69boJZC+jQPlqX02k4";
    public static final String SERVER_LICENSE = "AAABpw0ODAoPeNp9kc1u2zAQhO98igV6M0BZUuqkMaBDIrGui1oyLDlA/w4UvbZYS6RAUk789mVsJ\nwUatAdeljs7O9++W2gFd72B6BbC62k0mcYTmC0qiMM4IvnQ1WiK7dqisUkUhiTVynHhct5hUrda7\nZrBWEes47YJvkiBymJ17PHUULGymuczshyMaLjFjDtM/OCQhlc0ism/+i919tRLczyJllEcfnoxZ\nwsu2/+6v04q0RzQzLPknt0w+j77FtPr4vMNnV3dfiDlUFthZO+kVokzA5LRaJQXFf1YrOhyVWTrt\nJoXOV2XzH8kqUG/ygbqI7gG4WIHTAm9QQO90b9QOPjeONf/mI7HOx1w13JrJVeB0N24PSsonhU/A\n8g0KO1gI60zsh4c+snSgtMgBut056kHxKdVDhVX4i2Rc3LPRB7wNUK6YncVy+j91+e1xV6LRh/sX\nr5w9TjWaq/0oyIlyxP/6MSftjA7rqTlJxzsiXd9i5DqrufqSE7h/cffJ7xkevCbPstikuEfphVaB\n5cO2GoD20EJcL5qCTvwdjh7bXlrkfwGP7fbwDAtAhR+QdWNBnh1uLorI9T5KGrRdOPTFAIVAIFCD\ngnNasGeByLC++aVF0KH0B7hX02kc";
    public static final String SINGLE_USER_LICENSE = "AAABtQ0ODAoPeNqVUk2P2jAQvftXjNQbkkOgbNlFitQu8VKqkiASVurXwZiBuCR25A9a/n0NZLfa\nVj1Usi+eeW/ee+NXZeVhwQ0MbiEeTUY3k8EYZosShvFwQDLfbNDku7VFY5MBmWrluHAZ\nbzDZYOWbtjJ4sm+5q7m1kqtI6IZYx20VfZQClcXy1OKlv2RFOc9mZOmNqLjFlDtMwpSY\nxnfhkH/1d+/sZyvN6QJaDobx+yctbMFl/T9inokLNEc08zS5Z2NGR+nnIX2TfxjT2eu7\n2w4WxvEpKocmccYjKfzGCiNbJ7W6vvR6vSwv6UO+ostVnq6n5TzP6LpgoZBMDQa9W9ic\nwFUInQhgSugtGmiN/o7CwZfKufbrpN/f6+iF+H59RVC8Ir5FkGpQ2sFWWmfkxjsMzNKC\n0yC8dboJe4pIiCRoVlyJv2O7GgvBySM+W5iu2LuSpfT+01m2OGhR6aM9yKfwQ0hrdVD6\nhyIFy5Jw6U0ck9zsuZKWX+IozsTw4JWAEq2z5OI+VP5cdGfqMUg944Ykxd+hFlLtawQf\nPhx0jbDTBlygDCXCjrz214E7XlskvwBnRvERMCwCFCXAUPqCPId2904NUPU7jcMHp5d0\nAhRF83ciuAHMukX2kwZwbcKJFAfl2g==X02l1";
    public static final String UNLIMITED_LICENSE = "AAAB+w0ODAoPeNp1kktz2jAUhff6FZrpjo7B2DwCM16ALUiYgCmGzKSlC2FfsBpbciUZ4/z6iEdfy\nXSh1dG955xP+jSRDEdQYGeA7c7Q7Q8dF0/na+zYjoteoH4CqZjgXrtn2337znXbaFHmO5DhfqOM5\nllt5AuuaawXNAcvOYCQB1GIMhMKKU1V2nxkMXAF67qAy52APJHHcElWH/W/tGUp45QqCKgG7xzHs\ngeWM0D/33ZTyKlgsr6MLduOff8rH5lTlr0LGIE8gnwIvDHpE6sTfHWsXjjrW1N3cHdLZxZRH7gG6\nWlZAsquLvdG8+Z+5U/83s9xdz7a3UdqltRONZ7Pqk4eymM1G6UrNk27dlWu0i+d117dyz87s1N3G\nb2Gz6Ott/VQVO5ULFmhz5QvBo1GYxGurUm4sparMNj464dwYW0iYgTPl2CKJXhXY50CvlXGhMciA\nYkLKX5ArPG3VOtiO2y1DqJJdUaVYpQ3Y5G3bvEtuE58b+JAYC40TpjSku1KDWYzU1gLHJdKi9y8c\nhMZdgYBpzz+yPfKyRBmR/hdwV+R0ZoE1vj5HPtf6rfUBvuGv3BRcRSRhWeO1bVtFMoD5UzRCxFyo\nnmRAfZFXlBeo0t/I7z/FQH8obgGpfGtJ94LQyUrD4zjBI6QicL0QeRIs/LqsKeZAvQGaR4GyjAsA\nhQRirKtOyCLpt0WXFDKeXfCRiM12AIUbZQMIqvp1dO/kep3ARje0h3Vo6w=X02o0";

    public static JSONObject createLicenseBody(String license) {
        JSONObject body = new JSONObject();
        body.put((Object)"license", (Object)license);
        return body;
    }

    public static <T> T doWithLicense(Callable<T> runnable) throws Exception {
        String original = LicenseTestHelper.getLicense();
        try {
            T t = runnable.call();
            return t;
        }
        finally {
            LicenseTestHelper.setLicense(original);
        }
    }

    public static String getLicense() {
        return LicenseTestHelper.getLicenseJson().getString("license");
    }

    public static JsonPath getLicenseJson() {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(LicenseTestHelper.getLicenseURL(), new Object[0])).getBody().jsonPath();
    }

    public static void ensureLicensedUserCount(int expected) {
        int actual;
        long timeout = System.currentTimeMillis() + 10000L;
        do {
            if ((actual = LicenseTestHelper.getLicensedUserCount()) != expected) continue;
            return;
        } while (timeout > System.currentTimeMillis());
        Assert.assertEquals((String)("License count should match (users=" + UserTestHelper.allUsernames() + ")"), (long)expected, (long)actual);
    }

    public static int getLicensedUserCount() {
        return LicenseTestHelper.getLicenseJson().getInt("status.currentNumberOfUsers");
    }

    public static void setLicense(String license) {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("license", Matchers.equalTo((Object)license), new Object[0]).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().body((Object)LicenseTestHelper.createLicenseBody(license)).contentType(ContentType.JSON).post(LicenseTestHelper.getLicenseURL(), new Object[0]);
    }

    public static String getLicenseURL() {
        return DefaultFuncTestData.getRestURL() + "/admin/license";
    }
}

