/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.UserTestHelper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public final class HttpAccessTokensTestHelper {
    public static final String BASE_URL = DefaultFuncTestData.getRestURL("access-tokens", "latest");
    public static final String CREATED_DATE_KEY = "createdDate";
    public static final String EXPIRY_DAYS_KEY = "expiryDays";
    public static final String ID = "id";
    public static final String ID_KEY = "id";
    public static final String LAST_AUTHORIZED_KEY = "lastAuthorized";
    public static final String NAME = "name";
    public static final String NAME_KEY = "name";
    public static final String PERMISSIONS = "permissions";
    public static final String PERMISSIONS_KEY = "permissions";
    public static final Map<String, Object> ACCESS_TOKEN = ImmutableMap.builder().put((Object)"name", (Object)"dummy access token").put((Object)"permissions", (Object)ImmutableList.builder().add((Object)"REPO_ADMIN").build()).put((Object)"expiryDays", (Object)5).build();
    public static final Map<String, Object> REGULAR_USER = ImmutableMap.builder().put((Object)"emailAddress", (Object)"user@example.com").put((Object)"displayName", (Object)"User").put((Object)"name", (Object)DefaultFuncTestData.getRegularUser()).put((Object)"active", (Object)true).put((Object)"id", (Object)UserTestHelper.getUser(DefaultFuncTestData.getRegularUser()).getId()).put((Object)"type", (Object)"NORMAL").put((Object)"slug", (Object)DefaultFuncTestData.getRegularUser()).build();
    public static final String XSS_ACCESS_TOKEN_NAME = "</b><img src=x onerror=alert(1)>";
    public static final Map<String, Object> EXAMPLE_ACCESS_TOKEN = ImmutableMap.of((Object)"name", (Object)"</b><img src=x onerror=alert(1)>", (Object)"permissions", (Object)ImmutableList.of((Object)"REPO_ADMIN", (Object)"PROJECT_READ"), (Object)"expiryDays", (Object)2);
    private final String authUser;
    private final String password;
    private final List<String> pathParts;

    private HttpAccessTokensTestHelper(Builder builder) {
        this.authUser = builder.authUser;
        this.password = (String)MoreObjects.firstNonNull((Object)builder.password, (Object)this.authUser);
        this.pathParts = builder.repoSlug != null ? ImmutableList.of((Object)"projects", (Object)builder.projectKey, (Object)"repos", (Object)builder.repoSlug) : (builder.projectKey != null ? ImmutableList.of((Object)"projects", (Object)builder.projectKey) : ImmutableList.of((Object)"users", (Object)((String)MoreObjects.firstNonNull((Object)builder.tokenUser, (Object)builder.authUser))));
    }

    public static Map<String, Object> getBody(Response response) {
        return response.getBody().jsonPath().getMap("");
    }

    public static Integer getMaxExpiry() {
        return (Integer)((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(HttpAccessTokensTestHelper.getSettingsUrl(), new Object[0])).then()).extract().path("maxExpiryDays", new String[0]);
    }

    public static List<Map<String, Object>> getTokens(Response response) {
        return response.getBody().jsonPath().getList("values");
    }

    public static Response removeMaxExpiry() {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().delete(HttpAccessTokensTestHelper.getSettingsUrl(), new Object[0]);
    }

    public static Response setMaxExpiry(String maxExpiry) {
        return HttpAccessTokensTestHelper.setMaxExpiry(maxExpiry, Response.Status.OK.getStatusCode());
    }

    public static Response setMaxExpiry(String maxExpiry, int statusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser()).contentType("application/json").body((Object)ImmutableMap.of((Object)"maxExpiryDays", (Object)maxExpiry)).expect().statusCode(statusCode).log().ifValidationFails()).when().put(HttpAccessTokensTestHelper.getSettingsUrl(), new Object[0]);
    }

    private static String getSettingsUrl() {
        return BASE_URL + "/admin";
    }

    public String createToken(String tokenName, Permission ... permissions) {
        return (String)this.createToken((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)tokenName, (Object)"permissions", Arrays.stream(permissions).map(Enum::toString).collect(Collectors.toSet()))).jsonPath().get("token");
    }

    public Response createToken(Map<String, Object> tokenCreateRequest) {
        return this.createToken(tokenCreateRequest, Response.Status.OK.getStatusCode());
    }

    public Response createToken(Map<String, Object> tokenCreateRequest, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.authUser, this.password).contentType("application/json").body(tokenCreateRequest).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().put(this.getUrl(), new Object[0]);
    }

    public Response delete(String tokenId) {
        return this.delete(tokenId, Response.Status.NO_CONTENT.getStatusCode());
    }

    public Response delete(String tokenId, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.authUser, this.password).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().delete(this.getUrl() + "/" + tokenId, new Object[0]);
    }

    public void deleteAllTokens() {
        HttpAccessTokensTestHelper.getTokens(this.getTokens()).stream().map(token -> (String)token.get("id")).forEach(this::delete);
    }

    public Response getToken(String tokenId) {
        return this.getToken(tokenId, Response.Status.OK.getStatusCode());
    }

    public Response getToken(String tokenId, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.authUser, this.password).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.getUrl() + "/" + tokenId, new Object[0]);
    }

    public Response getTokens() {
        return this.getTokens(Response.Status.OK.getStatusCode());
    }

    public Response getTokens(int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.authUser, this.password).contentType("application/json").expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.getUrl(), new Object[0]);
    }

    public String getUrl() {
        return BASE_URL + "/" + String.join((CharSequence)"/", this.pathParts);
    }

    public Response modifyToken(String tokenId, Map<String, Object> tokenEditRequest) {
        return this.modifyToken(tokenId, tokenEditRequest, Response.Status.OK.getStatusCode());
    }

    public Response modifyToken(String tokenId, Map<String, Object> tokenEditRequest, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.authUser, this.password).contentType("application/json").body(tokenEditRequest).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().post(this.getUrl() + "/" + tokenId, new Object[0]);
    }

    public static class Builder {
        private final String authUser;
        private String password;
        private String projectKey;
        private String repoSlug;
        private String tokenUser;

        public Builder(String username) {
            this.authUser = username;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public Builder repoSlug(String repoSlug) {
            this.repoSlug = repoSlug;
            return this;
        }

        public Builder tokenUser(String username) {
            this.tokenUser = username;
            return this;
        }

        public HttpAccessTokensTestHelper build() {
            return new HttpAccessTokensTestHelper(this);
        }
    }
}

