/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.UpgradeTestUtils;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.Before;

public class AbstractSearchInstallerTest {
    protected static final String BITBUCKET_URL = "http://localhost:7990";
    protected static final String TEST_PROJECT_KEY = DefaultFuncTestData.getProject1();
    protected static final String TEST_REPO_SLUG = DefaultFuncTestData.getProject1Repository1();
    protected static final String TEST_SEARCH_QUERY = String.format("project:%s repo:%s symlink", TEST_PROJECT_KEY, TEST_REPO_SLUG);
    protected Path homeDirectory;
    protected Path installationDirectory;
    private DefaultFuncTestData.Context testDataContext;

    @Before
    public void setup() throws Exception {
        this.homeDirectory = Files.createDirectories(Paths.get("target", "home"), new FileAttribute[0]);
        this.installationDirectory = Files.createDirectories(Paths.get("target", "installer"), new FileAttribute[0]);
        Path applicationSharedHome = this.homeDirectory.resolve("shared");
        Files.createDirectories(applicationSharedHome, new FileAttribute[0]);
        Files.write(applicationSharedHome.resolve("bitbucket.properties"), UpgradeTestUtils.getSetupProperties("AAABow0ODAoPeNp1ksuO2jAUhvd5iiN1h+SQAC0tUhYziUsZlQSRsOht4YQDuE3syD5hytvXQzIXz\nagLb871+//jd2ut4K6rIZxCMFvMwsU0hOW6gEkwCby0a0o02WFn0dgoDAIv1opERaloMKpsVxpxR\npKeJWFP/ldZobJYXFq8FhQ8L1bp8m32KbPpTHUSFhNBGD2sZMGchVPvf5OGOP/bSnO5Nm3CSfDlE\nYuvhaxfcuVozmhWSXTL55zNku8T9iG7m7Pl9NPHActNETEqQhOR6dDLu9JWRrYkteojo9EozQr2O\nduyzTZLdnGxylK2y7lLRLFBh7GH8gJ0QhgAgatK79FAa/RvrAh+nIjan4vx+Kh9QbWwVgrlV7oZ1\n30Hw77jlw+JBqUJ9tKSkWVH6CZLC6Sh6izpxt3C95xSx6yEqt660QtzfsgzPkmIt/ym4Am7/faA/\ncKjAdmZtFN/lL5XXs7TyD323h08M0ehpBVXO24eyb2rbBd6fbgEn80r0BIM8uCgDRhX7AKNJCiNv\nnefCsjVSHX0+FnUXb/kIGqL3j8XnuGlMCsCEy+qBwzk4zefPyhmS1DIrx8BkmECFA1RqBGUyBFVw\n2F69boJZC+jQPlqX02k4"), new OpenOption[0]);
        this.testDataContext = DefaultFuncTestData.withBaseUrl(BITBUCKET_URL);
    }

    @After
    public void teardown() throws Exception {
        this.testDataContext.close();
        UpgradeTestUtils.maybeRunWithSudo("/bin/bash", "-c", String.format("chmod -R 755 %s", this.homeDirectory.toAbsolutePath()));
        UpgradeTestUtils.maybeRunWithSudo("/bin/bash", "-c", String.format("chmod -R 755 %s", this.installationDirectory.toAbsolutePath()));
    }
}

