/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.testcontainers;

import org.testcontainers.containers.GenericContainer;

public class LdapContainer
extends GenericContainer<LdapContainer> {
    public static final String LDAP_BASEDN = "dc=openstack,dc=org";
    public static final String LDAP_EXTERNAL_ID = "employeeNumber";
    public static final String LDAP_GROUP_DESCRIPTION = "description";
    public static final String LDAP_GROUP_DN = "ou=UserGroups";
    public static final String LDAP_GROUP_FILTER = "(objectclass=groupOfUniqueNames)";
    public static final String LDAP_GROUP_NAME = "cn";
    public static final String LDAP_GROUP_OBJECTCLASS = "groupOfUniqueNames";
    public static final String LDAP_GROUP_USERNAMES = "uniqueMember";
    public static final String LDAP_SERVER_PASSWORD = "password";
    public static final String LDAP_SERVER_USERNAME = "cn=admin,dc=openstack,dc=org";
    public static final String LDAP_USER_DISPLAYNAME = "cn";
    public static final String LDAP_USER_DN = "ou=Users";
    public static final String LDAP_USER_EMAIL = "mail";
    public static final String LDAP_USER_FILTER = "(objectclass=inetorgperson)";
    public static final String LDAP_USER_FIRSTNAME = "givenName";
    public static final String LDAP_USER_GROUP = "memberOf";
    public static final String LDAP_USER_LASTNAME = "sn";
    public static final String LDAP_USER_OBJECTCLASS = "inetorgperson";
    public static final String LDAP_USER_PASSWORD = "userPassword";
    public static final String LDAP_USER_USERNAME = "uid";
    public static final String LDAP_USER_USERNAME_RDN = "uid";
    private static final String LDAP_IMAGE = "docker.atl-paas.net/test-data/ldap-test-server";
    private static final int LDAP_PORT = 389;

    public LdapContainer(ContainerSize containerSize) {
        super("docker.atl-paas.net/test-data/ldap-test-server:" + containerSize.tag);
        this.withExposedPorts(new Integer[]{389});
    }

    public int getMappedLdapPort() {
        return this.getMappedPort(389);
    }

    public static enum ContainerSize {
        SMALL("small"),
        MEDIUM("medium"),
        MASSIVE("massive");

        private final String tag;

        private ContainerSize(String tag) {
            this.tag = tag;
        }
    }
}

