/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rules;

import java.util.Locale;
import javax.annotation.Nonnull;

public interface TestQualified {
    @Nonnull
    public static String cleanPart(@Nonnull String part) {
        return part.replaceAll("[^\\p{Alnum}\\-\\._]+", "-").replaceAll("-+$", "");
    }

    @Nonnull
    public static String uncamelise(@Nonnull String typeOrMethodName) {
        return TestQualified.uncamelise(typeOrMethodName, "-");
    }

    @Nonnull
    public static String uncamelise(@Nonnull String typeOrMethodName, @Nonnull String separator) {
        return typeOrMethodName.replaceAll("(?<=[^-_\\s])([A-Z]+)", separator + "$1").toLowerCase(Locale.ROOT);
    }

    @Nonnull
    default public String group() {
        return this.group("group");
    }

    @Nonnull
    public String group(@Nonnull String var1);

    @Nonnull
    default public String name(@Nonnull String base) {
        return this.name(base, Integer.MAX_VALUE);
    }

    @Nonnull
    public String name(@Nonnull String var1, int var2);

    @Nonnull
    default public String projectKey() {
        return this.projectKey("proj");
    }

    @Nonnull
    public String projectKey(@Nonnull String var1);

    @Nonnull
    default public String projectName() {
        return this.projectKey("proj");
    }

    @Nonnull
    public String projectName(@Nonnull String var1);

    @Nonnull
    default public String repoName() {
        return this.repoName("repo");
    }

    @Nonnull
    public String repoName(@Nonnull String var1);

    @Nonnull
    default public String repoSlug() {
        return this.repoSlug("repo");
    }

    @Nonnull
    public String repoSlug(@Nonnull String var1);

    @Nonnull
    default public String userName() {
        return this.userName("user");
    }

    @Nonnull
    public String userName(@Nonnull String var1);
}

