/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class MirroringRepoHelper {
    public static Response assertResponseAndGet(String url, Response.Status ... expectedStatuses) {
        ArrayList<Matcher> expected = new ArrayList<Matcher>();
        for (Response.Status expectedStatus : expectedStatuses) {
            expected.add(CoreMatchers.is((Object)expectedStatus.getStatusCode()));
        }
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType(ContentType.JSON).expect().statusCode((Matcher)CoreMatchers.anyOf(expected)).log().ifValidationFails()).when().get(url, new Object[0]);
    }

    public static Response expectSuccessfulResponse(String url) {
        return MirroringRepoHelper.assertResponseAndGet(url, Response.Status.OK);
    }

    private static String getRepoMirrorURL(int repoId) {
        return DefaultFuncTestData.getRestURL("mirroring", "latest") + "/repos/" + repoId + "/mirrors";
    }
}

