/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.hook.script;

import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class RestHookScriptHelper {
    private final String username;
    private final String password;

    public RestHookScriptHelper(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void configureForProject(long scriptId, String projectKey, RepositoryHookTrigger ... triggers) {
        this.configureForScope(scriptId, projectKey, null, triggers);
    }

    public void configureForRepository(long scriptId, String projectKey, String repoSlug, RepositoryHookTrigger ... triggers) {
        this.configureForScope(scriptId, projectKey, repoSlug, triggers);
    }

    public void configureForScope(long scriptId, String projectKey, String repoSlug, RepositoryHookTrigger ... triggers) {
        String triggerIdList = Arrays.stream(triggers).map(trigger -> "\"" + trigger.getId() + "\"").collect(Collectors.joining(","));
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.username, this.password).body("{\"triggerIds\":[" + triggerIdList + "]}").contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().put(DefaultFuncTestData.getScopeRestURL(projectKey, repoSlug) + "/hook-scripts/" + scriptId, new Object[0]);
    }

    public long createScript(String name, String contents, HookScriptType type) {
        return ((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.username, this.password).multiPart("content", contents).multiPart("description", name).multiPart("name", name).multiPart("type", type.name()).header("X-Atlassian-Token", (Object)"no-check", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().post(DefaultFuncTestData.getRestURL("api", "1.0") + "/hook-scripts", new Object[0])).jsonPath().getLong("id");
    }

    public void deleteConfiguration(long scriptId, String projectKey, String repoSlug) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.username, this.password).contentType("application/json").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifValidationFails()).when().delete(DefaultFuncTestData.getScopeRestURL(projectKey, repoSlug) + "/hook-scripts/" + scriptId, new Object[0]);
    }

    public void deleteScript(long scriptId) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.username, this.password).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifValidationFails()).when().delete(DefaultFuncTestData.getRestURL("api", "1.0") + "/hook-scripts/" + scriptId, new Object[0]);
    }

    public void deleteScriptSilently(long scriptId) {
        RestAssured.given().auth().preemptive().basic(this.username, this.password).when().delete(DefaultFuncTestData.getRestURL("api", "1.0") + "/hook-scripts/" + scriptId, new Object[0]);
    }

    public void updateScript(long scriptId, String name, String contents) {
        RequestSpecification requestSpec = RestAssured.given().auth().preemptive().basic(this.username, this.password);
        if (contents != null) {
            requestSpec.multiPart("content", contents);
        }
        if (name != null) {
            requestSpec.multiPart("description", name).multiPart("name", name);
        }
        ((Response)((ResponseSpecification)requestSpec.header("X-Atlassian-Token", (Object)"no-check", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().put(DefaultFuncTestData.getRestURL("api", "1.0") + "/hook-scripts/" + scriptId, new Object[0])).jsonPath().getLong("id");
    }
}

