/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Description;

public class ProjectSettingsRestrictionTestHelper {
    private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(10L);

    private ProjectSettingsRestrictionTestHelper() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static Request createRestriction(String projectKey, SettingsKey settingsKey) {
        return ProjectSettingsRestrictionTestHelper.createRestriction(projectKey, settingsKey.getNamespace(), settingsKey.getFeatureKey(), settingsKey.getComponentKey().orElse(null));
    }

    public static Request createRestriction(String projectKey, String namespace, String featureKey) {
        return ProjectSettingsRestrictionTestHelper.createRestriction(projectKey, namespace, featureKey, null);
    }

    public static Request createRestriction(String projectKey, String namespace, String featureKey, String componentKey) {
        Function<RequestSpecification, Response> action = request -> (Response)request.when().post(ProjectSettingsRestrictionTestHelper.getUrl(projectKey), new Object[0]);
        Function<RequestSpecification, RequestSpecification> content = request -> request.body(ProjectSettingsRestrictionTestHelper.restrictionJsonFor(namespace, featureKey, componentKey).toString());
        return new Request(action, content, Response.Status.OK.getStatusCode());
    }

    public static void createRestrictionAndWaitForProcessingState(String projectKey, SettingsKey settingsKey) {
        ProjectSettingsRestrictionTestHelper.createRestriction(projectKey, settingsKey).execute();
        ProjectSettingsRestrictionTestHelper.getRestrictionAndWaitForProcessing(projectKey, settingsKey);
    }

    public static void createRestrictionAndWaitForProcessingState(String projectKey, SettingsKey settingsKey, RestrictionProcessedState processedState) {
        ProjectSettingsRestrictionTestHelper.createRestriction(projectKey, settingsKey).execute();
        ProjectSettingsRestrictionTestHelper.getRestrictionAndWaitForProcessing(projectKey, settingsKey, processedState);
    }

    public static Request deleteRestriction(String projectKey, SettingsKey settingsKey) {
        return settingsKey.getComponentKey().map(componentKey -> ProjectSettingsRestrictionTestHelper.deleteRestriction(projectKey, settingsKey.getNamespace(), settingsKey.getFeatureKey(), componentKey)).orElse(ProjectSettingsRestrictionTestHelper.deleteRestriction(projectKey, settingsKey.getNamespace(), settingsKey.getFeatureKey()));
    }

    public static Request deleteRestriction(String projectKey, String namespace, String featureKey) {
        Function<RequestSpecification, Response> action = request -> (Response)request.when().delete(ProjectSettingsRestrictionTestHelper.getUrl(projectKey), new Object[0]);
        Function<RequestSpecification, RequestSpecification> content = request -> request.queryParam("featureKey", new Object[]{featureKey}).queryParam("namespace", new Object[]{namespace});
        return new Request(action, content, Response.Status.NO_CONTENT.getStatusCode());
    }

    public static Request deleteRestriction(String projectKey, String namespace, String featureKey, String componentKey) {
        Function<RequestSpecification, Response> action = request -> (Response)request.when().delete(ProjectSettingsRestrictionTestHelper.getUrl(projectKey), new Object[0]);
        Function<RequestSpecification, RequestSpecification> content = request -> request.queryParam("featureKey", new Object[]{featureKey}).queryParam("namespace", new Object[]{namespace}).queryParam("componentKey", new Object[]{componentKey});
        return new Request(action, content, Response.Status.NO_CONTENT.getStatusCode());
    }

    public static void deleteRestrictionAfterProcessing(String projectKey, SettingsKey settingsKey) {
        ProjectSettingsRestrictionTestHelper.deleteRestrictionAfterProcessing(projectKey, settingsKey, Function.identity());
    }

    public static void deleteRestrictionAfterProcessing(String projectKey, SettingsKey settingsKey, Function<Request, Request> requestProcessor) {
        final Request deleteRequest = requestProcessor.apply(ProjectSettingsRestrictionTestHelper.deleteRestriction(projectKey, settingsKey).statusCode(null));
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText("Restriction was never deleted after " + TIMEOUT + "ms.");
            }

            public boolean test() {
                return Response.Status.NO_CONTENT.getStatusCode() == deleteRequest.execute().getStatusCode();
            }
        }, (long)TIMEOUT);
    }

    public static Request getAllRestrictions(String projectKey, String namespace, String featureKey) {
        Function<RequestSpecification, Response> action = request -> (Response)request.when().get(ProjectSettingsRestrictionTestHelper.getUrl(projectKey) + "/all", new Object[0]);
        Function<RequestSpecification, RequestSpecification> content = request -> request.queryParam("featureKey", new Object[]{featureKey}).queryParam("namespace", new Object[]{namespace});
        return new Request(action, content, Response.Status.OK.getStatusCode());
    }

    public static Request getRestriction(String projectKey, SettingsKey settingsKey) {
        return settingsKey.getComponentKey().map(componentKey -> ProjectSettingsRestrictionTestHelper.getRestriction(projectKey, settingsKey.getNamespace(), settingsKey.getFeatureKey(), componentKey)).orElse(ProjectSettingsRestrictionTestHelper.getRestriction(projectKey, settingsKey.getNamespace(), settingsKey.getFeatureKey()));
    }

    public static Request getRestriction(String projectKey, String namespace, String featureKey) {
        Function<RequestSpecification, Response> action = request -> (Response)request.when().get(ProjectSettingsRestrictionTestHelper.getUrl(projectKey), new Object[0]);
        Function<RequestSpecification, RequestSpecification> content = request -> request.queryParam("featureKey", new Object[]{featureKey}).queryParam("namespace", new Object[]{namespace});
        return new Request(action, content, Response.Status.OK.getStatusCode());
    }

    public static Request getRestriction(String projectKey, String namespace, String featureKey, String componentKey) {
        Function<RequestSpecification, Response> action = request -> (Response)request.when().get(ProjectSettingsRestrictionTestHelper.getUrl(projectKey), new Object[0]);
        Function<RequestSpecification, RequestSpecification> content = request -> request.queryParam("featureKey", new Object[]{featureKey}).queryParam("namespace", new Object[]{namespace}).queryParam("componentKey", new Object[]{componentKey});
        return new Request(action, content, Response.Status.OK.getStatusCode());
    }

    public static void getRestrictionAndWait(String projectKey, SettingsKey settingsKey, final int statusCode) {
        final Request request = ProjectSettingsRestrictionTestHelper.getRestriction(projectKey, settingsKey).statusCode(null);
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText("Status code of retrieving restriction was never " + statusCode + " after " + TIMEOUT + "ms.");
            }

            public boolean test() {
                return statusCode == request.execute().statusCode();
            }
        }, (long)TIMEOUT);
    }

    public static void getRestrictionAndWait(String projectKey, String namespace, String featureKey, int statusCode) {
        ProjectSettingsRestrictionTestHelper.getRestrictionAndWait(projectKey, new SettingsKey.Builder(namespace, featureKey).build(), statusCode);
    }

    public static void getRestrictionAndWait(String projectKey, String namespace, String featureKey, String componentKey, int statusCode) {
        ProjectSettingsRestrictionTestHelper.getRestrictionAndWait(projectKey, new SettingsKey.Builder(namespace, featureKey).componentKey(componentKey).build(), statusCode);
    }

    public static Request getRestrictionAndWaitForProcessing(String projectKey, SettingsKey settingsKey) {
        return ProjectSettingsRestrictionTestHelper.getRestrictionAndWaitForProcessing(projectKey, settingsKey, RestrictionProcessedState.PROCESSED);
    }

    public static Request getRestrictionAndWaitForProcessing(String projectKey, SettingsKey settingsKey, final RestrictionProcessedState result) {
        final Request getRequest = ProjectSettingsRestrictionTestHelper.getRestriction(projectKey, settingsKey);
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText("Processed state of created restriction was never " + result.toString() + " after " + TIMEOUT + "ms.");
            }

            public boolean test() {
                return result == RestrictionProcessedState.valueOf((String)((String)getRequest.execute().getBody().jsonPath().get("processedState")));
            }
        }, (long)TIMEOUT);
        return getRequest;
    }

    private static String getUrl(String projectKey) {
        return DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/settings-restriction";
    }

    private static JSONObject restrictionJsonFor(String namespace, String featureKey, String componentKey) {
        JSONObject restriction = new JSONObject();
        if (featureKey != null) {
            restriction.put((Object)"featureKey", (Object)featureKey);
        }
        if (namespace != null) {
            restriction.put((Object)"namespace", (Object)namespace);
        }
        if (componentKey != null) {
            restriction.put((Object)"componentKey", (Object)componentKey);
        }
        return restriction;
    }

    public static class Request {
        private final Function<RequestSpecification, Response> action;
        private final Function<RequestSpecification, RequestSpecification> body;
        private Integer expectedStatusCode;
        private String password = DefaultFuncTestData.getAdminPassword();
        private String username = DefaultFuncTestData.getAdminUser();

        public Request(Function<RequestSpecification, Response> action, Function<RequestSpecification, RequestSpecification> body, Integer expectedStatusCode) {
            this.action = action;
            this.body = body;
            this.expectedStatusCode = expectedStatusCode;
        }

        public Request anonymous() {
            return this.user(null);
        }

        public Response execute() {
            RequestSpecification request = ((RequestSpecification)RestAssured.given().log().ifValidationFails()).contentType("application/json").request();
            request = this.withAuthentication(request);
            request = this.body.apply(request);
            if (this.expectedStatusCode != null) {
                request.expect().statusCode(this.expectedStatusCode.intValue());
            }
            return this.action.apply(request);
        }

        public Request statusCode(Integer expectedStatusCode) {
            this.expectedStatusCode = expectedStatusCode;
            return this;
        }

        public Request user(String username) {
            return this.user(username, username);
        }

        public Request user(String username, String password) {
            this.password = password;
            this.username = username;
            return this;
        }

        private RequestSpecification withAuthentication(RequestSpecification request) {
            if (this.password == null || this.username == null) {
                return request;
            }
            return request.auth().preemptive().basic(this.username, this.password);
        }
    }
}

