/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.OsgiPackageExports;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.springframework.core.io.ClassPathResource;

public final class OsgiTestUtils {
    public static final String EXTERNAL_PLUGIN = "com.example.plugin.bitbucket-it-test-external-plugin";
    public static final String EXTERNAL_PLUGIN_OSGI_RESOURCE = "osgi-external";
    public static final String INTERNAL_PLUGIN = "com.atlassian.bitbucket.server.bitbucket-it-rest";
    public static final String REST_TEST_OSGI_RESOURCE = "rest-tests";

    public static Set<String> findMissingExportsInBundle(OsgiPackageExports bundle, Map<String, OsgiPackageExports> expectedExports) {
        String bundleName = bundle.bundleName();
        return expectedExports.containsKey(bundleName) ? expectedExports.get(bundleName).findMissingExports(bundle) : Collections.emptySet();
    }

    public static Set<String> findUnexpectedExportsInBundle(OsgiPackageExports bundle, Map<String, OsgiPackageExports> expectedExports) {
        String bundleName = bundle.bundleName();
        if (expectedExports.containsKey(bundleName)) {
            return new TreeSet<String>(bundle.findMissingExports(expectedExports.get(bundleName)));
        }
        return Collections.emptySet();
    }

    public static List<OsgiPackageExports> getActualExports(String plugin) {
        return ((Response)((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(DefaultFuncTestData.getRestURL(REST_TEST_OSGI_RESOURCE, "1.0") + "/osgi/bundle/" + plugin + "/packages", new Object[0])).jsonPath().getList("", OsgiPackageExports.class);
    }

    public static Map<String, OsgiPackageExports> jsonFileToMap(String expectedExportsFile) {
        try {
            File resource = new ClassPathResource(expectedExportsFile).getFile();
            String exports = new String(Files.readAllBytes(resource.toPath()));
            Map map = (Map)new ObjectMapper().readValue(exports, HashMap.class);
            return map.entrySet().stream().map(entry -> new OsgiPackageExports((String)entry.getKey(), new HashSet<String>((Collection)entry.getValue()))).collect(Collectors.toMap(bundle -> bundle.bundleName(), bundle -> bundle));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read expected exports file", e);
        }
    }

    public static String prettyPrintBundlesMap(Map<String, Set<String>> bundles) {
        return bundles.entrySet().stream().map(bundle -> bundle.toString().replace("=", ":\n\t").replace(" ", "\n\t")).collect(Collectors.joining("\n"));
    }

    public static void saveBundleExportsToFile(List<OsgiPackageExports> actualExports, String filename) {
        TreeMap<String, Set<String>> exportsAsMap = new TreeMap<String, Set<String>>();
        for (OsgiPackageExports bundle : actualExports) {
            exportsAsMap.put(bundle.bundleName(), bundle.exportedPackages());
        }
        Path internalFile = Paths.get("target", filename);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        try {
            System.out.println("Writing OSGi bundle info to " + internalFile.toAbsolutePath());
            new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).writer((PrettyPrinter)prettyPrinter).writeValue(internalFile.toFile(), exportsAsMap);
        }
        catch (IOException e) {
            System.out.println("Failed to write bundle info to " + internalFile);
        }
    }
}

