/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Ignore;

@Ignore
public class GpgKeyTestHelper {
    public static Response addGpgKey(String username, String keyText) {
        return GpgKeyTestHelper.addGpgKey(username, keyText, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static Response addGpgKey(String keyOwnerName, String keyText, String loginUsername, String loginPassword) {
        return (Response)RestAssured.given().queryParam("user", new Object[]{keyOwnerName}).auth().preemptive().basic(loginUsername, loginPassword).contentType("application/json;charset=UTF-8").body(GpgKeyTestHelper.createKeyBody(keyText).toString()).expect().statusCode(200).when().post(GpgKeyTestHelper.gpgRestUrl("/keys"), new Object[0]);
    }

    public static Response deleteGpgKey(String keyIdOrFingerprint) {
        return GpgKeyTestHelper.deleteGpgKey(keyIdOrFingerprint, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static Response deleteGpgKey(String keyId, String loginUsername, String loginPassword) {
        return (Response)RestAssured.given().auth().preemptive().basic(loginUsername, loginPassword).contentType("application/json;charset=UTF-8").expect().statusCode(204).when().delete(GpgKeyTestHelper.gpgRestUrl("/keys/{id}"), new Object[]{keyId});
    }

    public static Response deleteGpgKeysForUser(String username) {
        return (Response)RestAssured.given().queryParam("user", new Object[]{username}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(204).when().delete(GpgKeyTestHelper.gpgRestUrl("/keys"), new Object[0]);
    }

    private static JSONObject createKeyBody(String keyText) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"text", (Object)keyText);
        return bodyObject;
    }

    private static String gpgRestUrl(String suffix) {
        return DefaultFuncTestData.getRestURL("gpg", "latest") + StringUtils.prependIfMissing((String)suffix, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

