/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import javax.ws.rs.core.Response;

public abstract class AbstractCommentLikeHelper {
    private final String projectKey;
    private final String repositorySlug;

    public AbstractCommentLikeHelper(String projectKey, String repositorySlug) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    public Response likeComment(long commentId, String username) {
        return this.likeComment(commentId, username, username);
    }

    public Response likeComment(long commentId, String username, String password) {
        String url = this.getCommentLikesURL(commentId);
        return (Response)this.getCommentLikesSpecification(username, password).when().post(url, new Object[0]);
    }

    public Response unlikeComment(long commentId) {
        return this.unlikeComment(commentId, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public Response unlikeComment(long commentId, String username) {
        return this.unlikeComment(commentId, username, username);
    }

    public Response unlikeComment(long commentId, String username, String password) {
        String url = this.getCommentLikesURL(commentId);
        return (Response)this.getCommentLikesSpecification(username, password).when().delete(url, new Object[0]);
    }

    public abstract String getCommentLikesURL(long var1);

    protected String getRepoBaseURL() {
        return DefaultFuncTestData.getRestURL("comment-likes", "latest") + "/projects/" + this.projectKey + "/repos/" + this.repositorySlug;
    }

    private ResponseSpecification getCommentLikesSpecification(String username, String password) {
        return RestAssured.given().auth().preemptive().basic(username, password).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError();
    }
}

