/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rules;

import com.atlassian.bitbucket.test.DarkFeatureTestHelper;
import com.atlassian.bitbucket.test.annotations.RequiresDarkFeature;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DarkFeatureRule
extends ExternalResource {
    private String[] initialFeatures;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RequiresDarkFeature annotation = (RequiresDarkFeature)description.getAnnotation(RequiresDarkFeature.class);
                try {
                    if (annotation != null) {
                        DarkFeatureRule.this.initialFeatures = DarkFeatureTestHelper.getEnabledFeatures();
                        String[] enabledFeatures = annotation.value();
                        DarkFeatureTestHelper.enableDarkFeatures(enabledFeatures);
                    }
                    base.evaluate();
                }
                finally {
                    if (annotation != null) {
                        DarkFeatureTestHelper.disableDarkFeatures(new String[0]);
                        DarkFeatureTestHelper.enableDarkFeatures(DarkFeatureRule.this.initialFeatures);
                    }
                }
            }
        };
    }
}

