/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.commit;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.test.rest.AbstractRestRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RestDiffRequest
extends AbstractRestRequest {
    private final Boolean autoSrcPath;
    private final AvatarRequest avatarRequest;
    private final Integer contextLines;
    private final Boolean markup;
    private final String path;
    private final Long pullRequestId;
    private final String since;
    private final String srcPath;
    private final DiffWhitespace whitespace;
    private final Boolean withComments;

    private RestDiffRequest(Builder builder) {
        super(builder);
        this.autoSrcPath = builder.autoSrcPath;
        this.avatarRequest = builder.avatarRequest;
        this.contextLines = builder.contextLines;
        this.markup = builder.markup;
        this.path = builder.path;
        this.pullRequestId = builder.pullRequestId;
        this.since = builder.since;
        this.srcPath = builder.srcPath;
        this.whitespace = builder.whitespace;
        this.withComments = builder.withComments;
    }

    @Nullable
    public Boolean getAutoSrcPath() {
        return this.autoSrcPath;
    }

    @Nullable
    public AvatarRequest getAvatarRequest() {
        return this.avatarRequest;
    }

    @Nullable
    public Integer getContextLines() {
        return this.contextLines;
    }

    @Nullable
    public Boolean getMarkup() {
        return this.markup;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getSince() {
        return this.since;
    }

    @Nullable
    public String getSrcPath() {
        return this.srcPath;
    }

    @Nullable
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    @Nullable
    public Boolean getWithComments() {
        return this.withComments;
    }

    @Override
    @Nonnull
    public Map<String, Object> toQueryParams() {
        LinkedHashMap params = Maps.newLinkedHashMap();
        if (this.autoSrcPath != null) {
            params.put("autoSrcPath", this.autoSrcPath);
        }
        if (this.avatarRequest != null) {
            params.put("avatarSize", this.avatarRequest.getSize());
            params.put("avatarScheme", this.avatarRequest.isSecure() ? "https" : "http");
        }
        if (this.contextLines != null) {
            params.put("contextLines", this.contextLines);
        }
        if (this.markup != null) {
            params.put("markup", this.markup);
        }
        if (this.pullRequestId != null) {
            params.put("pullRequestId", this.pullRequestId);
        }
        if (this.since != null) {
            params.put("since", this.since);
        }
        if (this.srcPath != null) {
            params.put("srcPath", this.srcPath);
        }
        if (this.whitespace != null) {
            params.put("whitespace", this.whitespace.name());
        }
        if (this.withComments != null) {
            params.put("withComments", this.withComments);
        }
        return params;
    }

    /* synthetic */ RestDiffRequest(Builder builder, RestDiffRequest restDiffRequest) {
        this(builder);
    }

    public static class Builder
    extends AbstractRestRequest.AbstractBuilder<Builder, RestDiffRequest> {
        private final String path;
        private Boolean autoSrcPath;
        private AvatarRequest avatarRequest;
        private Integer contextLines;
        private Boolean markup;
        private Long pullRequestId;
        private String since;
        private String srcPath;
        private DiffWhitespace whitespace;
        private Boolean withComments;

        public Builder(@Nonnull String path) {
            this.path = Builder.checkNotBlank((String)path, (String)"path");
        }

        public Builder(@Nonnull RestDiffRequest request) {
            super(request);
            this.autoSrcPath = request.getAutoSrcPath();
            this.avatarRequest = request.getAvatarRequest();
            this.contextLines = request.getContextLines();
            this.path = Builder.checkNotBlank((String)request.getPath(), (String)"request.path");
            this.since = request.getSince();
            this.srcPath = request.getSrcPath();
            this.whitespace = request.getWhitespace();
            this.withComments = request.getWithComments();
        }

        @Nonnull
        public Builder autoSrcPath(boolean value) {
            this.autoSrcPath = value;
            return this.self();
        }

        @Nonnull
        public Builder avatars(boolean secure, int size) {
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"The minimum size for avatars is 1px");
            return this.avatars(new AvatarRequest(secure, size));
        }

        @Nonnull
        public Builder avatars(@Nullable AvatarRequest value) {
            this.avatarRequest = value;
            return this.self();
        }

        @Override
        @Nonnull
        public RestDiffRequest build() {
            return new RestDiffRequest(this, null);
        }

        @Nonnull
        public Builder contextLines(@Nullable Integer value) {
            this.contextLines = value;
            return this.self();
        }

        @Nonnull
        public Builder markup(@Nullable Boolean value) {
            this.markup = value;
            return this.self();
        }

        @Nonnull
        public Builder pullRequestId(@Nullable Long value) {
            this.pullRequestId = value;
            return this.self();
        }

        @Nonnull
        public Builder since(@Nullable String value) {
            this.since = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder srcPath(@Nullable String value) {
            this.srcPath = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder whitespace(@Nullable DiffWhitespace value) {
            this.whitespace = value;
            return this.self();
        }

        @Nonnull
        public Builder withComments(@Nullable Boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

