/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.atlassian.bitbucket.test.rest.AbstractRestRequest;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestPagedRequest
extends AbstractRestRequest {
    private final PageRequest pageRequest;

    protected RestPagedRequest(AbstractPagedRequestBuilder<?, ?> builder) {
        super(builder);
        this.pageRequest = ((AbstractPagedRequestBuilder)builder).pageRequest;
    }

    @Nullable
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    @Override
    @Nonnull
    public Map<String, Object> toQueryParams() {
        LinkedHashMap params = Maps.newLinkedHashMap();
        if (this.pageRequest != null) {
            params.put("start", this.pageRequest.getStart());
            params.put("limit", this.pageRequest.getLimit());
        }
        return params;
    }

    protected static abstract class AbstractPagedRequestBuilder<B extends AbstractPagedRequestBuilder<B, R>, R extends RestPagedRequest>
    extends AbstractRestRequest.AbstractBuilder<B, R> {
        private PageRequest pageRequest;

        protected AbstractPagedRequestBuilder() {
        }

        protected AbstractPagedRequestBuilder(@Nonnull R request) {
            super(request);
            this.pageRequest = ((RestPagedRequest)request).getPageRequest();
        }

        @Nonnull
        public B page(int start, int limit) {
            return this.page(PageUtils.newRequest((int)start, (int)limit));
        }

        @Nonnull
        public B page(@Nullable PageRequest value) {
            this.pageRequest = value;
            return (B)((Object)((AbstractPagedRequestBuilder)((Object)this.self())));
        }
    }

    public static class Builder
    extends AbstractPagedRequestBuilder<Builder, RestPagedRequest> {
        public Builder() {
        }

        public Builder(@Nonnull RestPagedRequest request) {
            super(request);
        }

        @Override
        @Nonnull
        public RestPagedRequest build() {
            return new RestPagedRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

