/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestAuthentication {
    private final String password;
    private final String username;

    private RestAuthentication() {
        this.username = null;
        this.password = null;
    }

    private RestAuthentication(String username, String password) {
        this.password = password;
        this.username = username;
    }

    public static RestAuthentication anonymous() {
        return new RestAuthentication();
    }

    public static RestAuthentication authenticated(@Nonnull String username) {
        return RestAuthentication.authenticated(username, username);
    }

    public static RestAuthentication authenticated(@Nonnull String username, @Nullable String password) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)username, (Object)"username")).isEmpty() ? 1 : 0) != 0, (Object)"A username is required for an authenticated request.");
        return new RestAuthentication(username, password);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAuthenticated() {
        return this.username != null;
    }
}

