/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.jayway.jsonassert.JsonAssert;
import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;

public class ResponseMatchers {
    private ResponseMatchers() {
        throw new UnsupportedOperationException(String.valueOf(ResponseMatchers.class.getName()) + " should not be instantiated");
    }

    public static Matcher<Integer> successful() {
        return Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(Response.Status.OK.getStatusCode())), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(300)));
    }

    public static Matcher<Integer> accepted() {
        return ResponseMatchers.forStatus(Response.Status.ACCEPTED);
    }

    public static Matcher<Integer> badRequest() {
        return ResponseMatchers.forStatus(Response.Status.BAD_REQUEST);
    }

    public static Matcher<Integer> conflict() {
        return ResponseMatchers.forStatus(Response.Status.CONFLICT);
    }

    public static Matcher<Integer> noContent() {
        return ResponseMatchers.forStatus(Response.Status.NO_CONTENT);
    }

    public static Matcher<Integer> notFound() {
        return ResponseMatchers.forStatus(Response.Status.NOT_FOUND);
    }

    public static Matcher<Integer> ok() {
        return ResponseMatchers.forStatus(Response.Status.OK);
    }

    public static Matcher<Integer> unauthorized() {
        return ResponseMatchers.forStatus(Response.Status.UNAUTHORIZED);
    }

    private static Matcher<Integer> forStatus(Response.Status status) {
        return Matchers.is((Object)status.getStatusCode());
    }

    @SafeVarargs
    public static Matcher<? super Object> pathContainsInAnyOrder(final String path, final Matcher<? super Object> ... matchers) {
        final JsonProvider jsonProvider = Configuration.defaultConfiguration().jsonProvider();
        final Collection transformedMatchers = Collections2.transform(Arrays.asList(matchers), (Function)new Function<Matcher<? super Object>, Matcher<? super Object>>(){

            public Matcher<? super Object> apply(final Matcher<? super Object> matcher) {
                return new BaseMatcher<Object>(){

                    public boolean matches(Object item) {
                        String json = jsonProvider.toJson(item);
                        return matcher.matches((Object)json);
                    }

                    public void describeTo(Description description) {
                        matcher.describeTo(description);
                    }
                };
            }
        });
        return new BaseMatcher<Object>(){

            public boolean matches(Object json) {
                try {
                    JsonAssert.with((String)((String)json)).assertThat(path, Matchers.containsInAnyOrder((Collection)transformedMatchers));
                    return true;
                }
                catch (AssertionError assertionError) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText(String.valueOf(path) + " is (in any order) ");
                int i = 0;
                while (i < matchers.length) {
                    description.appendText("[");
                    description.appendDescriptionOf((SelfDescribing)matchers[i]);
                    description.appendText("[");
                    if (i != matchers.length - 1) {
                        description.appendText(", ");
                    }
                    ++i;
                }
            }
        };
    }

    public static Matcher<? super Object> matchingValues(final Object ... keyAndMatchers) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object json) {
                JsonAsserter asserter = JsonAssert.with((String)((String)json));
                try {
                    int i = 0;
                    while (i < keyAndMatchers.length) {
                        asserter.assertThat((String)keyAndMatchers[i], (Matcher)keyAndMatchers[i + 1]);
                        i += 2;
                    }
                    return true;
                }
                catch (AssertionError assertionError) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                int i = 0;
                while (i < keyAndMatchers.length) {
                    description.appendText(keyAndMatchers[i] + " is ");
                    description.appendDescriptionOf((SelfDescribing)((Matcher)keyAndMatchers[i + 1]));
                    if (i != keyAndMatchers.length - 2) {
                        description.appendText(", ");
                    }
                    i += 2;
                }
            }
        };
    }
}

