/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ResponsePage;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.google.common.collect.Lists;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public class RefRestrictionTestHelper
extends ExternalResource {
    private final String project;
    private final String repo;
    private List<Integer> createdRestrictedRefs = Lists.newArrayList();

    public RefRestrictionTestHelper(String project) {
        this.project = project;
        this.repo = null;
    }

    public RefRestrictionTestHelper(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    protected void after() {
        for (Integer id : this.createdRestrictedRefs) {
            this.deleteRestrictedRef(id, null);
        }
    }

    public void deleteAll() {
        for (JSONObject ref : this.getAll().getValues()) {
            this.deleteRestrictedRef(ref.getInt("id"), null);
        }
    }

    public ResponsePage<JSONObject> getAll() {
        return new ResponsePage<JSONObject>(this.getAll(200, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body().jsonPath(), RestTestHelper.JSON_TRANSFORM);
    }

    public Response getAll(Integer expectedResponseCode, String username, String password) {
        Matcher httpCodeMatcher = expectedResponseCode != null ? Matchers.equalTo((Object)expectedResponseCode) : Matchers.any(Integer.class);
        return (Response)((RequestSpecification)RestAssured.expect().statusCode(httpCodeMatcher).given().auth().preemptive().basic(username, password).contentType("application/json").log().ifValidationFails()).when().get(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
    }

    public Response deleteRestrictedRef(int restrictedRefId, Integer expectedResponseCode) {
        return this.deleteRestrictedRef(restrictedRefId, expectedResponseCode, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public Response deleteRestrictedRef(int restrictedRefId, Integer expectedResponseCode, String username, String password) {
        Matcher httpCodeMatcher = expectedResponseCode != null ? Matchers.equalTo((Object)expectedResponseCode) : Matchers.any(Integer.class);
        return (Response)RestAssured.expect().statusCode(httpCodeMatcher).given().auth().preemptive().basic(username, password).contentType("application/json").when().delete(String.valueOf(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo)) + "/" + restrictedRefId, new Object[0]);
    }

    public RefRestrictionResponse createRestrictedRef(RestrictedRefRequest restrictedRefRequest) {
        IdMatcher idMatcher = new IdMatcher();
        Response response = this.postRestrictedRef(RefRestrictionTestHelper.restrictedRefRequestBody(restrictedRefRequest).toString(), restrictedRefRequest.expectedStatusCode, (Matcher)idMatcher, restrictedRefRequest.password, restrictedRefRequest.username);
        if (idMatcher.getId() != null) {
            this.createdRestrictedRefs.add(idMatcher.getId());
        }
        if (restrictedRefRequest.expectedStatusCode == 200) {
            this.assertRestrictedRefValues(idMatcher.getId(), restrictedRefRequest.type, restrictedRefRequest.matcherId);
        }
        return new RefRestrictionResponse(idMatcher.getId(), response);
    }

    public RefRestrictionResponse updateRestrictedRef(RestrictedRefRequest restrictedRefRequest) {
        Response response = this.postRestrictedRef(RefRestrictionTestHelper.restrictedRefRequestBody(restrictedRefRequest).toString(), restrictedRefRequest.expectedStatusCode, Matchers.equalTo((Object)restrictedRefRequest.id), restrictedRefRequest.password, restrictedRefRequest.username);
        if (restrictedRefRequest.id != null) {
            this.createdRestrictedRefs.add(restrictedRefRequest.id);
        }
        if (restrictedRefRequest.expectedStatusCode == 200) {
            this.assertRestrictedRefValues(restrictedRefRequest.id, restrictedRefRequest.type, restrictedRefRequest.matcherId);
        }
        return new RefRestrictionResponse(restrictedRefRequest.id, response);
    }

    @Deprecated
    public Integer createRestrictedRef(RefMatcherType refMatcherType, String matcherId, RestrictionType restrictionType) {
        return this.createRestrictedRef(refMatcherType, matcherId, restrictionType, null, null, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    @Deprecated
    public Integer createRestrictedRef(RefMatcherType refMatcherType, String matcherId, RestrictionType restrictionType, Collection<String> users, Collection<String> groups) {
        return this.createRestrictedRef(refMatcherType, matcherId, restrictionType, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    @Deprecated
    public Integer createRestrictedRef(RefMatcherType refMatcherType, String matcherId, RestrictionType restrictionType, Collection<String> users, Collection<String> groups, String username, String password) {
        return this.createRestrictedRef(new RestrictedRefRequest(refMatcherType, matcherId, restrictionType).users(users).groups(groups).username(username).password(password)).getId();
    }

    @Deprecated
    public void updateRestrictedRef(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups) {
        this.updateRestrictedRef(id, refMatcherType, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    @Deprecated
    public void updateRestrictedRef(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        this.updateRestrictedRef(new RestrictedRefRequest(refMatcherType, value, RestrictionType.READ_ONLY).id(id).users(users).groups(groups).username(username).password(password));
    }

    @Deprecated
    public void updateRestrictedRefExpectingUnauthorized(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        this.updateRestrictedRefExpectingCode(id, refMatcherType, value, users, groups, username, password, 401);
    }

    @Deprecated
    public void updateRestrictedRefExpectingCode(int id, RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password, int code) {
        this.updateRestrictedRef(new RestrictedRefRequest(refMatcherType, value, RestrictionType.READ_ONLY).id(id).expectedStatusCode(code).users(users).groups(groups).username(username).password(password));
    }

    @Deprecated
    public Response createRestrictedRefExpectingBadRequest(RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups) {
        return this.createRestrictedRefExpectingHttpCode(refMatcherType, value, users, groups, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 400);
    }

    @Deprecated
    public Response createRestrictedRefExpectingUnauthorized(RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password) {
        return this.createRestrictedRefExpectingHttpCode(refMatcherType, value, users, groups, username, password, 401);
    }

    @Deprecated
    public Response createRestrictedRefExpectingHttpCode(RefMatcherType refMatcherType, String value, Collection<String> users, Collection<String> groups, String username, String password, int httpCode) {
        return this.createRestrictedRef(new RestrictedRefRequest(refMatcherType, value, RestrictionType.READ_ONLY).expectedStatusCode(httpCode).users(users).groups(groups).username(username).password(password)).getResponse();
    }

    private void assertRestrictedRefValues(Integer id, RefMatcherType refMatcherType, String value) {
        String matcherTypeId = refMatcherType == null ? null : refMatcherType.name();
        RestAssured.expect().statusCode(200).body("id", Matchers.equalTo((Object)id), new Object[0]).body("matcher.type.id", Matchers.equalTo((Object)matcherTypeId), new Object[0]).body("matcher.id", Matchers.equalTo((Object)value), new Object[0]).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").when().get(String.valueOf(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo)) + "/" + id, new Object[0]);
    }

    private static String baseRestrictedRefUrl(String projectKey, String repositorySlug) {
        return String.valueOf(DefaultFuncTestData.getRestURL("branch-permissions", "2.0")) + "/projects/" + projectKey + (repositorySlug == null ? "" : "/repos/" + repositorySlug) + "/restrictions";
    }

    private Response postRestrictedRef(String body, int statusCode, Matcher idMatcher, String password, String username) {
        ResponseSpecification spec = RestAssured.expect().statusCode(statusCode).log().ifError();
        if (statusCode == 200) {
            spec.body("id", idMatcher, new Object[0]);
        }
        return (Response)spec.given().auth().preemptive().basic(username, password).body(body).contentType("application/json").when().post(RefRestrictionTestHelper.baseRestrictedRefUrl(this.project, this.repo), new Object[0]);
    }

    private static JSONObject restrictedRefRequestBody(@Nonnull RestrictedRefRequest restrictedRefRequest) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)restrictedRefRequest.id);
        JSONObject matcher = new JSONObject();
        JSONObject refMatcherType = new JSONObject();
        if (restrictedRefRequest.type != null) {
            refMatcherType.put((Object)"id", (Object)restrictedRefRequest.type.name());
        }
        matcher.put((Object)"type", (Object)refMatcherType);
        matcher.put((Object)"id", (Object)restrictedRefRequest.matcherId);
        obj.put((Object)"matcher", (Object)matcher);
        if (!restrictedRefRequest.accessKeys.isEmpty()) {
            obj.put((Object)"accessKeys", (Object)restrictedRefRequest.accessKeys);
        }
        if (!restrictedRefRequest.users.isEmpty()) {
            obj.put((Object)"users", (Object)restrictedRefRequest.users);
        }
        if (!restrictedRefRequest.groups.isEmpty()) {
            obj.put((Object)"groups", (Object)restrictedRefRequest.groups);
        }
        if (restrictedRefRequest.restrictionType != null) {
            obj.put((Object)"type", (Object)restrictedRefRequest.restrictionType.getId());
        }
        return obj;
    }

    private static class IdMatcher
    extends BaseMatcher<Object> {
        private Integer id;

        private IdMatcher() {
        }

        public Integer getId() {
            return this.id;
        }

        public boolean matches(Object o) {
            if (o instanceof Number) {
                this.id = ((Number)o).intValue();
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            Matchers.any(Number.class).describeTo(description);
        }
    }

    public static enum RefMatcherType {
        BRANCH,
        PATTERN,
        MODEL_CATEGORY,
        MODEL_BRANCH;

    }

    public class RefRestrictionResponse {
        private final Integer id;
        private final Response response;

        RefRestrictionResponse(Integer id, Response response) {
            this.id = id;
            this.response = response;
        }

        public Integer getId() {
            return this.id;
        }

        public Response getResponse() {
            return this.response;
        }
    }

    public static class RestrictedRefRequest {
        private final Collection<String> accessKeys;
        private final Collection<String> users;
        private final Collection<String> groups;
        private final String matcherId;
        private final RestrictionType restrictionType;
        private final RefMatcherType type;
        private int expectedStatusCode = 200;
        private Integer id = null;
        private String password = DefaultFuncTestData.getAdminPassword();
        private String username = DefaultFuncTestData.getAdminUser();

        public RestrictedRefRequest(RefMatcherType type, String matcherId, RestrictionType restrictionType) {
            this.matcherId = matcherId;
            this.restrictionType = restrictionType;
            this.type = type;
            this.accessKeys = new ArrayList<String>();
            this.users = new ArrayList<String>();
            this.groups = new ArrayList<String>();
        }

        public RestrictedRefRequest accessKeys(Collection<String> value) {
            if (value != null) {
                this.accessKeys.addAll(value);
            }
            return this;
        }

        public RestrictedRefRequest expectedStatusCode(int value) {
            this.expectedStatusCode = value;
            return this;
        }

        public RestrictedRefRequest groups(Collection<String> value) {
            if (value != null) {
                this.groups.addAll(value);
            }
            return this;
        }

        public RestrictedRefRequest id(Integer value) {
            this.id = value;
            return this;
        }

        public RestrictedRefRequest password(String value) {
            this.password = value;
            return this;
        }

        public RestrictedRefRequest users(Collection<String> value) {
            if (value != null) {
                this.users.addAll(value);
            }
            return this;
        }

        public RestrictedRefRequest username(String value) {
            this.username = value;
            return this;
        }
    }

    public static enum RestrictionType {
        READ_ONLY("read-only", true),
        NO_DELETES("no-deletes", false),
        FAST_FORWARD_ONLY("fast-forward-only", false),
        PULL_REQUEST_ONLY("pull-request-only", false);

        private final String id;
        private final boolean supportsPermissions;

        private RestrictionType(String id, boolean supportsPermissions) {
            this.id = id;
            this.supportsPermissions = supportsPermissions;
        }

        public String getId() {
            return this.id;
        }

        public boolean supportsPermissions() {
            return this.supportsPermissions;
        }
    }
}

