/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.google.common.collect.ImmutableMap;
import com.jayway.restassured.RestAssured;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class MergeStrategiesTestHelper
extends AbstractRestHelper {
    public static final String FF_ID = "ff";
    public static final Map<String, Object> FF = ImmutableMap.of((Object)"id", (Object)"ff");
    public static final String FF_ONLY_ID = "ff-only";
    public static final String MERGE_CONFIG = "mergeConfig";
    public static final String NO_FF_ID = "no-ff";
    public static final Map<String, Object> NO_FF = ImmutableMap.of((Object)"id", (Object)"no-ff");
    public static final String REBASE_FF_ONLY_ID = "rebase-ff-only";
    public static final String REBASE_NO_FF_ID = "rebase-no-ff";
    public static final String SQUASH_ID = "squash";
    public static final String SQUASH_FF_ONLY_ID = "squash-ff-only";
    public static final String URL = String.valueOf(DefaultFuncTestData.getRepositoryRestURL(DefaultFuncTestData.getProject1(), DefaultFuncTestData.getProject1Repository1())) + "/settings/pull-requests";

    protected MergeStrategiesTestHelper(@Nullable RestAuthentication defaultAuthentication) {
        super(defaultAuthentication);
    }

    public static void clearMergeStrategies(String url) throws Exception {
        MergeStrategiesTestHelper.clearMergeStrategies(url, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static void clearMergeStrategies(String url, String user, String password) throws Exception {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().contentType("application/json").given().auth().preemptive().basic(user, password).body(MergeStrategiesTestHelper.getEmptyMergeStrategiesBody()).contentType("application/json").when().post(url, new Object[0]);
    }

    public static String getEmptyMergeStrategiesBody() throws Exception {
        JSONObject mergeStrategies = new JSONObject();
        mergeStrategies.put((Object)MERGE_CONFIG, (Object)new JSONObject());
        return mergeStrategies.toString();
    }

    @SafeVarargs
    public static String getMergeStrategiesBody(Map<String, Object> defaultMap, Map<String, Object> ... strategies) throws Exception {
        JSONObject mergeStrategies = new JSONObject();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (defaultMap != null) {
            builder.put((Object)"defaultStrategy", defaultMap);
        }
        if (strategies != null) {
            builder.put((Object)"strategies", strategies);
        }
        mergeStrategies.put((Object)MERGE_CONFIG, (Object)builder.build());
        return mergeStrategies.toString();
    }

    @SafeVarargs
    public static void setMergeStrategies(Map<String, Object> defaultMap, Map<String, Object> ... strategies) throws Exception {
        MergeStrategiesTestHelper.setMergeStrategies(URL, defaultMap, strategies);
    }

    @SafeVarargs
    public static void setMergeStrategies(String url, Map<String, Object> defaultMap, Map<String, Object> ... strategies) throws Exception {
        MergeStrategiesTestHelper.setMergeStrategies(url, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), defaultMap, strategies);
    }

    @SafeVarargs
    public static void setMergeStrategies(String url, String user, String password, Map<String, Object> defaultMap, Map<String, Object> ... strategies) throws Exception {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().contentType("application/json").given().auth().preemptive().basic(user, password).body(MergeStrategiesTestHelper.getMergeStrategiesBody(defaultMap, strategies)).contentType("application/json").when().post(url, new Object[0]);
    }
}

