/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.BitbucketTestLicense;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.UserTestHelper;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LicenseTestHelper {
    public static final int DEFAULT_LICENSED_USER_COUNT = 2;
    public static final BitbucketTestLicense SINGLE_USER_LICENSE = BitbucketTestLicense.builder().whenClustered("AAABMg0ODAoPeNp9UdFqwjAUffcrAnuuNKkwJgSmbRTBVln1YY934VYDNZWbVObfL9YIGwwhD+Gck\n3PPPXlZkGEFasYF49mUi2n2xpbljomUT0bOgzuO1QXaHrzprGygdRjhAp0mcx7w2thDi6x3SKw1G\nq1D1nTEPDofqPgiJxxsCvAowwCRpFmSvj7YznrQvoITyiV2TcNyAmMjW4arRwtWo/o+G7pGE5EmK\nQ8nyoKBuaD01ONfWxUMWnnQN8t38C04Z8COdXeKulpVkotsMqqRLkirQs7Vfp2IImSs1HyV1J/LW\ndSu7yvurmcc4uabslQf+Wq2joItkLdIAxmhDR3AGnfvsb5BbNFbzXahIveoFDzkGPak3xtse9JHc\nPh/bTHLs1Kq/vSFtGn24Xuc5KMf6LOp4DAsAhRUNDa4MG5ybx1ePBFUhWtIreodPgIUGLMhHJgU3\nXAY3PyxXEeZ1OAzVcU=X02fb").whenNonClustered("AAABKg0ODAoPeNp9UNFqwjAUffcrAnuupNUhCIFpm0nBVlkrY4932W0N1FRuUpl/v1izB/cwyENyz\nrkn95ynd/xiBRDjCxbz5Xy+fF4wWdUs4XEysQ7scSov0A3gdG9EA53FAGdoFenziFfatB2ywSKxT\nis0FlnTE3NonafCREo42mTgUNw+iPgs4otftjcOlCvhhGKDfdOwlECbwBb+6tCAUSi/z5quwSThE\nY/9CTJvoC8oHA34aCu9QSdadbN8AdeBtRrMVPWnoKtkKeJkNg/P7T1FfT3juFG6Kwr5luar7aRCu\niDlmVjLwzZKMh+ilOs8qj42qzC9B3IGaZwM0I5aMNree6xuEHsdjGK1r8gGTTmcPpF2zcH3aEX8u\nMp/sfcDqSNY/NvsDwp0ocgwLQIVAI0R9FKxOPeWevWwkPN8i1Mrjw95AhR6RSuj4xrxEy7SFE+kS\nPFYPFVmjw==X02f3").build();

    public static JSONObject createLicenseBody(String license) {
        JSONObject body = new JSONObject();
        body.put((Object)"license", (Object)license);
        return body;
    }

    public static <T> T doWithLicense(Callable<T> runnable) throws Exception {
        String original = LicenseTestHelper.getLicense();
        try {
            T t = runnable.call();
            return t;
        }
        finally {
            LicenseTestHelper.setLicense(original);
        }
    }

    public static String getLicense() {
        return LicenseTestHelper.getLicenseJson().getString("license");
    }

    public static JsonPath getLicenseJson() {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(LicenseTestHelper.getLicenseURL(), new Object[0])).getBody().jsonPath();
    }

    public static void ensureLicensedUserCount(int expected) {
        int actual;
        long timeout = System.currentTimeMillis() + 10000L;
        do {
            if ((actual = LicenseTestHelper.getLicensedUserCount()) != expected) continue;
            return;
        } while (timeout > System.currentTimeMillis());
        Assert.assertEquals((String)("License count should match (users=" + UserTestHelper.allUsernames() + ")"), (long)expected, (long)actual);
    }

    public static int getLicensedUserCount() {
        return LicenseTestHelper.getLicenseJson().getInt("status.currentNumberOfUsers");
    }

    public static void setLicense(String license) {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("license", Matchers.equalTo((Object)license), new Object[0]).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().body((Object)LicenseTestHelper.createLicenseBody(license)).contentType(ContentType.JSON).post(LicenseTestHelper.getLicenseURL(), new Object[0]);
    }

    public static String getLicenseURL() {
        return String.valueOf(DefaultFuncTestData.getRestURL()) + "/admin/license";
    }
}

