/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.jayway.jsonassert.JsonAssert;
import com.jayway.jsonassert.JsonAsserter;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public abstract class JsonMatcher
extends TypeSafeMatcher<String> {
    private final Consumer<JsonAsserter> test;

    public JsonMatcher(Consumer<JsonAsserter> test) {
        this.test = test;
    }

    protected boolean matchesSafely(String json) {
        try {
            this.test.accept(JsonAssert.with((String)json));
            return true;
        }
        catch (AssertionError assertionError) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Matcher<String> propEqualsIgnoreCase(final String path, final String value) {
        return new JsonMatcher(json -> {
            JsonAsserter jsonAsserter = json.assertThat(path, Matchers.equalToIgnoringCase((String)value));
        }){

            public void describeTo(Description description) {
                description.appendText("JSON path ").appendValue((Object)path).appendText(" with case-insensitive string \"").appendValue((Object)value).appendText("\"");
            }
        };
    }

    public static Matcher<String> propIs(final String path, final boolean value) {
        return new JsonMatcher(json -> {
            JsonAsserter jsonAsserter = json.assertThat(path, Matchers.is((Object)value));
        }){

            public void describeTo(Description description) {
                description.appendText("JSON path ").appendValue((Object)path).appendText(" id \"").appendValue((Object)value).appendText("\"");
            }
        };
    }

    public static Matcher<String> propNotNull(final String path) {
        return new JsonMatcher(json -> {
            JsonAsserter jsonAsserter = json.assertNotNull(path);
        }){

            public void describeTo(Description description) {
                description.appendText("Non-null JSON path ").appendValue((Object)path);
            }
        };
    }
}

