/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.google.common.base.Preconditions;
import com.jayway.restassured.path.json.JsonPath;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;

public class JsonMatchers {
    private JsonMatchers() {
        throw new UnsupportedOperationException(JsonMatchers.class.getName() + " should not be instantiated");
    }

    @Nonnull
    public static Matcher<Iterable<? extends Map<String, Object>>> containsError(@Nonnull Matcher<? super Map<String, Object>> matcher) {
        return Matchers.contains(matcher);
    }

    @Nonnull
    public static Matcher<Map<? extends String, ?>> hasJsonEntry(@Nonnull Matcher<String> keyMatcher, @Nonnull Matcher<?> valueMatcher) {
        return Matchers.hasEntry(keyMatcher, valueMatcher);
    }

    @Nonnull
    public static Matcher<Map<? extends String, ?>> hasJsonEntry(@Nullable String key, @Nullable Object expectedValue) {
        return JsonMatchers.hasJsonEntry((Matcher<String>)Matchers.is((Object)key), Matchers.is((Object)expectedValue));
    }

    @Nonnull
    public static Matcher<Map<String, Object>> hasRestErrorsThat(@Nonnull Matcher<Iterable<? extends Map<String, Object>>> errorsMatcher) {
        return AllOf.allOf(JsonMatchers.isMapWithSize(1), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"errors"), errorsMatcher));
    }

    @Nonnull
    public static Matcher<JsonPath> isErrorResponseThat(@Nonnull Matcher<Iterable<? extends Map<String, Object>>> errorsMatcher) {
        return new FeatureMatcher<JsonPath, Map<String, Object>>(JsonMatchers.hasRestErrorsThat(errorsMatcher), "JSON map that", "JSON map"){

            protected Map<String, Object> featureValueOf(JsonPath actual) {
                return (Map)actual.get();
            }
        };
    }

    public static Matcher<JsonPath> isLastPage() {
        return JsonMatchers.isLastPage(true);
    }

    public static Matcher<JsonPath> isLastPage(final boolean isLast) {
        return new TypeSafeMatcher<JsonPath>(){

            protected boolean matchesSafely(@Nonnull JsonPath json) {
                return Boolean.valueOf(isLast).equals(json.getObject("isLastPage", Boolean.class));
            }

            public void describeTo(Description description) {
                if (isLast) {
                    description.appendText("a last page of a JSON collection");
                } else {
                    description.appendText("a non-last page of a JSON collection");
                }
            }
        };
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> isMapWithSize(final int size) {
        return new TypeSafeMatcher<Map<? extends K, ? extends V>>(){

            protected boolean matchesSafely(Map<? extends K, ? extends V> map) {
                return map.size() == size;
            }

            public void describeTo(Description description) {
                description.appendText("a map with size ").appendValue((Object)size);
            }
        };
    }

    public static Matcher<JsonPath> isPageMatching(int expectedSize, boolean isLast) {
        return AllOf.allOf(JsonMatchers.isPageWithSize(expectedSize), JsonMatchers.isLastPage(isLast));
    }

    public static Matcher<JsonPath> isPageWithSize(int expectedSize) {
        return JsonMatchers.isPageWithSize((Matcher<Integer>)Matchers.equalTo((Object)expectedSize));
    }

    @Nonnull
    public static Matcher<JsonPath> isPageWithSize(@Nonnull Matcher<Integer> sizeMatcher) {
        Preconditions.checkNotNull(sizeMatcher, (Object)"sizeMatcher");
        return new FeatureMatcher<JsonPath, Integer>(sizeMatcher, "page size that", "size"){

            protected Integer featureValueOf(@Nonnull JsonPath json) {
                return (Integer)json.getObject("size", Integer.class);
            }
        };
    }

    @Nonnull
    public static Matcher<Map<String, Object>> isRestErrorWithMessage(@Nonnull String expectedMessage) {
        return JsonMatchers.isRestErrorThat(null, (Matcher<String>)Matchers.is((Object)expectedMessage), null);
    }

    @Nonnull
    public static Matcher<Map<String, Object>> isRestErrorWithMessageThat(@Nonnull Matcher<String> messageMatcher) {
        return JsonMatchers.isRestErrorThat(null, messageMatcher, null);
    }

    @Nonnull
    public static Matcher<Map<String, Object>> isRestErrorThat(@Nullable Matcher<String> contextMatcher, @Nonnull Matcher<String> messageMatcher, @Nullable Matcher<String> exceptionNameMatcher) {
        Preconditions.checkNotNull(messageMatcher, (Object)"messageMatcher");
        Matcher answer = JsonMatchers.hasJsonEntry((Matcher<String>)Matchers.is((Object)"message"), messageMatcher);
        if (contextMatcher != null) {
            answer = Matchers.allOf(answer, JsonMatchers.hasJsonEntry((Matcher<String>)Matchers.is((Object)"context"), contextMatcher));
        }
        if (exceptionNameMatcher != null) {
            answer = Matchers.allOf((Matcher)answer, JsonMatchers.hasJsonEntry((Matcher<String>)Matchers.is((Object)"exceptionName"), exceptionNameMatcher));
        }
        return answer;
    }

    @Nonnull
    public static Matcher<Map<String, Object>> isRestErrorWith(@Nullable String expectedContext, @Nonnull String expectedMessage) {
        return JsonMatchers.isRestErrorWith(expectedContext, expectedMessage, null);
    }

    @Nonnull
    public static Matcher<Map<String, Object>> isRestErrorWith(@Nullable String expectedContext, @Nonnull String expectedMessage, @Nullable String expectedExceptionName) {
        Preconditions.checkNotNull((Object)expectedMessage, (Object)"expectedMessage");
        return JsonMatchers.isRestErrorThat((Matcher<String>)Matchers.is((Object)expectedContext), (Matcher<String>)Matchers.is((Object)expectedMessage), (Matcher<String>)Matchers.is((Object)expectedExceptionName));
    }
}

