/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ResponsePage;
import com.atlassian.bitbucket.test.rest.RestRequest;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.internal.http.URIBuilder;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.Assert;

public class RestTestHelper {
    public static final Function<Object, JSONObject> JSON_TRANSFORM = new Function<Object, JSONObject>(){

        public JSONObject apply(Object o) {
            return JSONObject.fromObject((Object)o);
        }
    };
    private final String password;
    private final String username;

    public RestTestHelper(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static String buildUrl(@Nonnull String baseUrl, @Nonnull RestRequest request) {
        Map<String, Object> params = request.toQueryParams();
        URIBuilder builder = RestTestHelper.createUriBuilder(baseUrl);
        if (!params.isEmpty()) {
            try {
                builder.addQueryParams(params);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return builder.toString();
    }

    public Response delete(String path, Response.Status expectedStatus) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(this.username, this.password).contentType("application/json").when().delete(DefaultFuncTestData.getRestURL() + path, new Object[0]);
        RestTestHelper.assertStatus("Empty DELETE to path " + path + " did not return expected status", expectedStatus, response);
        return response;
    }

    public JsonPath get(String path, Response.Status expectedStatus) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(this.username, this.password).contentType("application/json").when().get(DefaultFuncTestData.getRestURL() + path, new Object[0]);
        RestTestHelper.assertStatus("GET from path " + path + " did not return expected status", expectedStatus, response);
        return response.getBody().jsonPath();
    }

    public ResponsePage<JSONObject> getPage(String path, Response.Status expectedStatus) {
        return new ResponsePage<JSONObject>(this.get(path, expectedStatus), JSON_TRANSFORM);
    }

    public Response post(String path, Response.Status expectedStatus) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(this.username, this.password).contentType("application/json").when().post(DefaultFuncTestData.getRestURL() + path, new Object[0]);
        RestTestHelper.assertStatus("Empty POST to path " + path + " did not return expected status", expectedStatus, response);
        return response;
    }

    public Response put(String path, Response.Status expectedStatus) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(this.username, this.password).contentType("application/json").when().put(DefaultFuncTestData.getRestURL() + path, new Object[0]);
        RestTestHelper.assertStatus("Empty PUT to path " + path + " did not return expected status", expectedStatus, response);
        return response;
    }

    public static void assertStatus(String message, Response.Status status, Response response) {
        if (response.getStatusCode() != status.getStatusCode()) {
            Assert.fail((String)(message + " - Unexpected status : " + response.getStatusCode() + ", body = " + response.getBody().asString()));
        }
    }

    public static BaseMatcher<Object> captureLongId(final MutableLong value) {
        return new BaseMatcher<Object>(){

            public void describeTo(Description description) {
                description.appendText("ID should be non-null");
            }

            public boolean matches(Object id) {
                if (value != null && id instanceof Number) {
                    value.setValue((Number)id);
                }
                return id != null;
            }
        };
    }

    public static List<JSONObject> extractValues(JsonPath path) {
        return RestTestHelper.extractValues(path, "values");
    }

    public static List<JSONObject> extractValues(JsonPath path, String name) {
        return Lists.transform((List)path.getList(name), JSON_TRANSFORM);
    }

    public static List<JSONObject> extractValues(Response response) {
        return RestTestHelper.extractValues(response, "values");
    }

    public static List<JSONObject> extractValues(Response response, String name) {
        return RestTestHelper.extractValues(response.body().jsonPath(), name);
    }

    public static boolean hasValue(Response response, String attributeName, String attributeValue, boolean caseSensitive) {
        List<JSONObject> values = RestTestHelper.extractValues(response);
        for (JSONObject value : values) {
            String attribute = value.get(attributeName).toString();
            if (caseSensitive && attributeValue.equals(attribute)) {
                return true;
            }
            if (caseSensitive || !attributeValue.equalsIgnoreCase(attribute)) continue;
            return true;
        }
        return false;
    }

    private static URIBuilder createUriBuilder(@Nonnull String url) {
        return new URIBuilder(URI.create(url), false, EncoderConfig.encoderConfig().defaultContentCharset("UTF-8"));
    }
}

