/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.ProductTopologyVisitor;
import java.util.Locale;

public enum ProductTopology {
    BITBUCKET_STANDALONE("bitbucket.standalone"){

        @Override
        public <T> T accept(ProductTopologyVisitor<T> visitor) {
            return visitor.visitStashStandalone();
        }
    }
    ,
    BITBUCKET_CLUSTER_PAIR("bitbucket.cluster.pair"){

        @Override
        public <T> T accept(ProductTopologyVisitor<T> visitor) {
            return visitor.visitStashClusterPair();
        }
    };

    private final String propertyName;

    private ProductTopology(String propertyName) {
        this.propertyName = propertyName;
    }

    public abstract <T> T accept(ProductTopologyVisitor<T> var1);

    public static ProductTopology get() {
        String value = System.getProperty("test.product.topology", ProductTopology.BITBUCKET_STANDALONE.propertyName).toLowerCase(Locale.US).trim();
        for (ProductTopology topology : ProductTopology.values()) {
            if (!topology.propertyName.equals(value)) continue;
            return topology;
        }
        return BITBUCKET_STANDALONE;
    }
}

