/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.PermissionsTestHelper;
import com.atlassian.bitbucket.test.UserTestHelper;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class GroupTestHelper {
    public static void createGroups(String ... names) {
        GroupTestHelper.createGroups(Arrays.asList(names));
    }

    public static void createGroups(Iterable<String> names) {
        for (String name : names) {
            RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().queryParam("name", new Object[]{name}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().post(DefaultFuncTestData.getRestURL() + "/admin/groups", new Object[0]);
        }
    }

    public static void deleteGroups(boolean ignoreIfNotPresent, String ... names) {
        GroupTestHelper.deleteGroups(ignoreIfNotPresent, Arrays.asList(names));
    }

    public static void deleteGroups(boolean ignoreIfNotPresent, Iterable<String> names) {
        for (String name : names) {
            Response response = (Response)RestAssured.given().queryParam("name", new Object[]{name}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().delete(DefaultFuncTestData.getRestURL() + "/admin/groups", new Object[0]);
            int status = response.getStatusCode();
            if (ignoreIfNotPresent) {
                Assert.assertThat((Object)status, (Matcher)Matchers.either((Matcher)Matchers.is((Object)Response.Status.OK.getStatusCode())).or(Matchers.is((Object)Response.Status.NOT_FOUND.getStatusCode())));
                continue;
            }
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)status);
        }
    }

    public static void removeUserFromGroup(boolean ignoreIfNotPresent, String group, String user) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"context", (Object)group);
        bodyObject.put((Object)"itemName", (Object)user);
        Matcher expectedStatus = ignoreIfNotPresent ? Matchers.isOneOf((Object[])new Integer[]{Response.Status.OK.getStatusCode(), Response.Status.NOT_FOUND.getStatusCode()}) : Matchers.is((Object)Response.Status.OK.getStatusCode());
        RestAssured.expect().statusCode(expectedStatus).given().body((Object)bodyObject).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().post(DefaultFuncTestData.getRestURL() + "/admin/groups/remove-user", new Object[0]);
    }

    public static void addUserToGroups(Iterable<String> groups, String user) {
        for (String group : groups) {
            GroupTestHelper.addUserToGroup(group, user);
        }
    }

    public static void addUserToGroup(String group, String user) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"context", (Object)group);
        bodyObject.put((Object)"itemName", (Object)user);
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().body((Object)bodyObject).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().post(DefaultFuncTestData.getRestURL() + "/admin/groups/add-user", new Object[0]);
    }

    public static boolean isUserInGroup(String user, String group) {
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().queryParam("context", new Object[]{group}).queryParam("filter", new Object[]{user}).queryParam("start", new Object[]{0}).queryParam("pageSize", new Object[]{(short)Short.MAX_VALUE}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().get(DefaultFuncTestData.getRestURL() + "/admin/groups/more-members", new Object[0]);
        return UserTestHelper.hasUser(response, user);
    }

    public static void createGroupWithPermissionAndUsers(String group, String permission, String ... users) {
        GroupTestHelper.createGroups(group);
        for (String user : users) {
            GroupTestHelper.addUserToGroup(group, user);
        }
        PermissionsTestHelper.setGlobalPermissionForGroup(group, permission);
    }
}

