/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.junit.HashedTestNameRule;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.test.TestContext;
import com.atlassian.bitbucket.test.annotations.CompatibleWithProductTopologies;
import com.atlassian.bitbucket.test.rules.TestClassQualified;
import com.atlassian.bitbucket.test.rules.TestNameQualified;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

@CompatibleWithProductTopologies
public abstract class BaseFuncTest {
    @ClassRule
    public static final TemporaryFolder tempFolder = new TemporaryFolder();
    @ClassRule
    public static final TestClassQualified testClassQualified = new TestClassQualified(BaseFuncTest.class);
    private static final String ADMIN_DISPLAY_NAME = "Administrator";
    private static final ThreadLocal<TestContext> classTestContext = new ThreadLocal();
    @Rule
    public HashedTestNameRule hashedTestName = new HashedTestNameRule();
    protected final TestNameQualified testNameQualified = new TestNameQualified(this::getTestRunDifferentiator);
    protected final TestContext testContext = new MethodTestContext();
    private String uniqueAdminUsername;
    private String uniqueAdminPassword;

    @ClassRule
    public static TestContext createClassTestContext() {
        ClassTestContext context = new ClassTestContext();
        classTestContext.set(context);
        return context;
    }

    protected static TestContext getClassTestContext() {
        return classTestContext.get();
    }

    @Rule
    public final RuleChain createTestRuleChain() {
        RuleChain chain = RuleChain.emptyRuleChain();
        for (TestRule rule : this.getRuleChain()) {
            chain = chain.around(rule);
        }
        return chain;
    }

    @Before
    public void setupTestSpecificData() {
        this.uniqueAdminPassword = this.uniqueAdminUsername = "admin-" + this.hashedTestName.toString();
        this.testContext.user(this.uniqueAdminUsername, ADMIN_DISPLAY_NAME, this.uniqueAdminUsername).globalPermission(this.uniqueAdminUsername, Permission.SYS_ADMIN);
    }

    public String getAdminUser() {
        return this.uniqueAdminUsername;
    }

    public String getAdminName() {
        return ADMIN_DISPLAY_NAME;
    }

    public String getAdminPassword() {
        return this.uniqueAdminPassword;
    }

    protected List<TestRule> getRuleChain() {
        return Arrays.asList(this.testNameQualified, this.testContext, tempFolder);
    }

    protected String getTestRunDifferentiator() {
        return "";
    }

    private static class MethodTestContext
    extends TestContext {
        private MethodTestContext() {
        }
    }

    private static class ClassTestContext
    extends TestContext {
        private ClassTestContext() {
        }
    }
}

