/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.parser;

import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BaseObject;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class BaseObjectParser {
    private static final Pattern GIT_LFS_POINTER;
    private static final Set<String> SUPPORTED_VERSIONS;

    @Nonnull
    public Optional<BaseObject> parse(@Nonnull byte[] data) {
        Objects.requireNonNull(data, "data");
        Matcher matcher = GIT_LFS_POINTER.matcher(new String(data, StandardCharsets.UTF_8));
        return matcher.matches() ? BaseObjectParser.toBaseObject(matcher) : Optional.empty();
    }

    private static Optional<BaseObject> toBaseObject(Matcher matcher) {
        long size;
        String oid = matcher.group("oid");
        if (!GitLfsUtils.isValidSha256(oid)) {
            return Optional.empty();
        }
        try {
            size = Long.parseLong(matcher.group("size"));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        return Optional.of(new BaseObject(oid, size));
    }

    static {
        SUPPORTED_VERSIONS = ImmutableSet.of((Object)"https://git-lfs.github.com/spec/v1", (Object)"https://hawser.github.com/spec/v1");
        String version = "^version (?:" + String.join((CharSequence)"|", SUPPORTED_VERSIONS) + ")$\n";
        String oid = "^oid sha256:(?<oid>[a-f0-9]+)$\n";
        String size = "^size (?<size>\\d+)$\n";
        GIT_LFS_POINTER = Pattern.compile(version + oid + size, 8);
    }
}

