/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.ssh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchRequestException;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.ssh.GitLfsAuthenticateScmRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestContext;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestHandler;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitLfsSshScmRequestHandler
implements SshScmRequestHandler {
    private static final String EXT = "(?:\\.git)?";
    private static final String GIT_LFS_AUTHENTICATE_COMMAND = "git-lfs-authenticate";
    private static final String LEADING_SLASH = "/?";
    private static final String NAMESPACE = "((?<namespace>[^/']+)/)?";
    private static final String PROJECT = "(?<project>[^/]+)/";
    private static final String REPO = "(?<repo>[^/']+?)";
    private static final Pattern PATTERN_NAMESPACE_PROJECT_REPOSITORY = Pattern.compile(String.format("%s%s%s%s%s", "/?", "((?<namespace>[^/']+)/)?", "(?<project>[^/]+)/", "(?<repo>[^/']+?)", "(?:\\.git)?"));
    private static final Logger log = LoggerFactory.getLogger(GitLfsSshScmRequestHandler.class);
    private final I18nService i18nService;
    private final GitLfsJwtHelper jwtHelper;
    private final NavBuilder navBuilder;
    private final RepositoryService repositoryService;
    private final GitLfsSettingsService settingsService;

    public GitLfsSshScmRequestHandler(I18nService i18nService, GitLfsJwtHelper jwtHelper, NavBuilder navBuilder, RepositoryService repositoryService, GitLfsSettingsService settingsService) {
        this.i18nService = i18nService;
        this.jwtHelper = jwtHelper;
        this.navBuilder = navBuilder;
        this.repositoryService = repositoryService;
        this.settingsService = settingsService;
    }

    @Nonnull
    public Optional<SshScmRequest> create(@Nonnull SshScmRequestContext context) {
        String command = context.getCommand();
        if (!this.supports(command) || !this.settingsService.isEnabled()) {
            return Optional.empty();
        }
        String[] tokens = command.split("\\s+");
        if (GIT_LFS_AUTHENTICATE_COMMAND.equals(tokens[0])) {
            log.trace("{} is a supported git command; extracting repository", (Object)command);
            if (tokens.length < 2) {
                throw new BadBatchRequestException(this.i18nService.getMessage("bitbucket.scm.git.lfs.request.missing.attribute", new Object[]{"repository path"}));
            }
            if (tokens.length < 3) {
                throw new BadBatchRequestException(this.i18nService.getMessage("bitbucket.scm.git.lfs.request.missing.attribute", new Object[]{"operation"}));
            }
            Matcher matcher = PATTERN_NAMESPACE_PROJECT_REPOSITORY.matcher(tokens[1]);
            if (matcher.matches()) {
                Repository repository;
                String projectKey = matcher.group("project");
                String repositorySlug = matcher.group("repo");
                String op = tokens[2];
                if (log.isTraceEnabled()) {
                    log.trace("Extracted project key {} repository slug {} operation {}; loading repository", new Object[]{projectKey, repositorySlug, op});
                }
                try {
                    repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
                }
                catch (RepositoryMovedException e) {
                    repository = e.getRepository();
                }
                if (repository == null) {
                    throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.nosuchrepo", new Object[]{projectKey, repositorySlug}), null);
                }
                return Optional.of(new GitLfsAuthenticateScmRequest(repository, switch (op) {
                    case "download" -> false;
                    case "upload" -> true;
                    default -> throw new BadBatchRequestException(this.i18nService.getMessage("bitbucket.scm.git.lfs.request.unsupported.operation", new Object[]{op}));
                }, context.getExitCodeCallback(), this.i18nService, this.jwtHelper, this.navBuilder, context.getStdout(), this.settingsService));
            }
        }
        return Optional.empty();
    }

    public boolean supports(@Nonnull String command) {
        return command.startsWith(GIT_LFS_AUTHENTICATE_COMMAND);
    }
}

