/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.LfsContentCache;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.NeverExpireStrategy;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.atlassian.util.contentcache.EvictionStrategy;
import com.atlassian.util.contentcache.NoOpEvictionStrategy;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.AbstractContentCacheManager;
import com.atlassian.util.contentcache.internal.NoOpStreamPumper;
import java.util.Objects;
import javax.annotation.Nonnull;

public class LfsContentCacheManager
extends AbstractContentCacheManager {
    private final EvictionStrategy evictionStrategy;
    private final CacheExpiryStrategy expiryStrategy;
    private final LfsFileSystemHelper lfsFileSystemHelper;
    private final GitLfsSettingsService settingsService;

    private LfsContentCacheManager(Builder builder) {
        super(builder.streamPumper, builder.evictionStrategy, Long.MAX_VALUE);
        this.expiryStrategy = builder.expiryStrategy;
        this.evictionStrategy = builder.evictionStrategy;
        this.lfsFileSystemHelper = builder.lfsFileSystemHelper;
        this.settingsService = builder.settingsService;
    }

    protected ContentCache createContentCache(String regionKey, StreamPumper streamPumper) {
        return new LfsContentCache(this.lfsFileSystemHelper, this.expiryStrategy, (ContentCacheManager)this, this.evictionStrategy, this.settingsService, streamPumper);
    }

    public static class Builder {
        private EvictionStrategy evictionStrategy;
        private CacheExpiryStrategy expiryStrategy = new NeverExpireStrategy();
        private LfsFileSystemHelper lfsFileSystemHelper;
        private GitLfsSettingsService settingsService;
        private StreamPumper streamPumper;

        public Builder() {
            this.evictionStrategy = new NoOpEvictionStrategy();
            this.streamPumper = new NoOpStreamPumper();
        }

        public LfsContentCacheManager build() {
            return new LfsContentCacheManager(this);
        }

        public Builder evictionStrategy(@Nonnull EvictionStrategy value) {
            Objects.requireNonNull(value, "value");
            this.evictionStrategy = value;
            return this;
        }

        public Builder lfsFileSystemHelper(@Nonnull LfsFileSystemHelper value) {
            this.lfsFileSystemHelper = Objects.requireNonNull(value, "value");
            return this;
        }

        public Builder settingsService(@Nonnull GitLfsSettingsService value) {
            this.settingsService = Objects.requireNonNull(value, "value");
            return this;
        }

        public Builder streamPumper(@Nonnull StreamPumper value) {
            this.streamPumper = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

