/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.BaseLfsHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockCreateScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockDeleteScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockListScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockVerifyScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;

public class DefaultLfsLockHttpScmRequestHandler
extends BaseLfsHttpScmRequestHandler
implements LfsLockHttpScmRequestHandler {
    private final AuthenticationContext authenticationContext;
    private final LfsLockService lfsLockService;
    private final LfsService lfsService;
    private final Validator validator;

    public DefaultLfsLockHttpScmRequestHandler(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull LfsLockService lfsLockService, @Nonnull LfsService lfsService, @Nonnull RepositoryService repositoryService, @Nonnull Validator validator) {
        super(repositoryService, i18nService);
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext");
        this.lfsLockService = Objects.requireNonNull(lfsLockService, "lfsLockService");
        this.lfsService = Objects.requireNonNull(lfsService, "lfsService");
        this.validator = Objects.requireNonNull(validator, "validator");
    }

    @Nonnull
    public Optional<HttpScmRequest> create(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(response, "response");
        Matcher lockApiMatcher = LfsHttpScmUtils.LFS_HTTP_LOCK_PATH.matcher(request.getPathInfo());
        if (lockApiMatcher.matches()) {
            Repository repository = this.getRepositoryOrThrow(lockApiMatcher);
            String lockPath = lockApiMatcher.group("lockpath");
            if (StringUtils.isEmpty((CharSequence)lockPath)) {
                if ("POST".equals(request.getMethod())) {
                    return Optional.of(new LfsLockCreateScmRequest(this.authenticationContext, this.i18nService, this.lfsLockService, repository, request, response, this.validator));
                }
                if ("GET".equals(request.getMethod())) {
                    return Optional.of(new LfsLockListScmRequest(this.authenticationContext, this.i18nService, this.lfsLockService, repository, request, response));
                }
            }
            if ("/verify".equals(lockPath)) {
                return Optional.of(new LfsLockVerifyScmRequest(this.authenticationContext, this.i18nService, this.lfsLockService, repository, request, response));
            }
            return Optional.of(new LfsLockDeleteScmRequest(this.authenticationContext, this.i18nService, this.lfsLockService, repository, request, response, this.validator, lockPath));
        }
        return Optional.empty();
    }

    public boolean supports(@Nonnull HttpRequestDetails requestDetails) {
        Objects.requireNonNull(requestDetails, "requestDetails");
        return LfsHttpScmUtils.isLockApiCall(requestDetails) && this.lfsService.isEnabled();
    }
}

