/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest;

import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/admin")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class GitLfsAdminResource {
    private final LfsService lfsService;

    @Inject
    public GitLfsAdminResource(LfsService lfsService) {
        this.lfsService = lfsService;
    }

    @DELETE
    @Path(value="/enabled")
    @WebSudoRequired
    public Response disableLfs() {
        this.lfsService.disable();
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    public Response disableLfs(@BeanParam RepositoryResolver repositoryResolver) {
        this.lfsService.disable(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="/enabled")
    @WebSudoRequired
    public Response enableLfs() {
        this.lfsService.enable();
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    public Response enableLfs(@BeanParam RepositoryResolver repositoryResolver) {
        this.lfsService.enable(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="/enabled")
    public Response getEnabled() {
        if (this.lfsService.isEnabled()) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.notFound().build();
    }

    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    public Response getEnabled(@BeanParam RepositoryResolver repositoryResolver) {
        if (this.lfsService.isEnabled(repositoryResolver.getRepository())) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.notFound().build();
    }
}

