/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.DefaultLfsLockHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.MirrorLfsLockHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.DefaultUpstreamLfsClient;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class LfsLockHttpScmRequestHandlerFactoryBean
extends AbstractFactoryBean<LfsLockHttpScmRequestHandler> {
    private final AuthenticationContext authenticationContext;
    private final BundleContext context;
    private final I18nService i18nService;
    private final JsonRenderer jsonRenderer;
    private final LfsLockService lfsLockService;
    private final LfsService lfsService;
    private final ApplicationMode mode;
    private final RepositoryService repositoryService;
    private final RequestManager requestManager;
    private final Validator validator;

    public LfsLockHttpScmRequestHandlerFactoryBean(@Nonnull AuthenticationContext authenticationContext, @Nonnull BundleContext context, @Nonnull I18nService i18nService, @Nonnull JsonRenderer jsonRenderer, @Nonnull LfsLockService lfsLockService, @Nonnull LfsService lfsService, @Nonnull ApplicationPropertiesService propertiesService, @Nonnull RepositoryService repositoryService, @Nonnull RequestManager requestManager, @Nonnull Validator validator) {
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext");
        this.context = Objects.requireNonNull(context, "context");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.jsonRenderer = Objects.requireNonNull(jsonRenderer, "jsonRenderer");
        this.lfsLockService = Objects.requireNonNull(lfsLockService, "lfsLockService");
        this.lfsService = Objects.requireNonNull(lfsService, "lfsService");
        this.mode = Objects.requireNonNull(propertiesService, "propertiesService").getMode();
        this.repositoryService = Objects.requireNonNull(repositoryService, "repositoryService");
        this.requestManager = Objects.requireNonNull(requestManager, "requestManager");
        this.validator = Objects.requireNonNull(validator, "validator");
    }

    public Class<?> getObjectType() {
        return LfsLockHttpScmRequestHandler.class;
    }

    protected LfsLockHttpScmRequestHandler createInstance() {
        return this.mode == ApplicationMode.DEFAULT ? new DefaultLfsLockHttpScmRequestHandler(this.authenticationContext, this.i18nService, this.lfsLockService, this.lfsService, this.repositoryService, this.validator) : new MirrorLfsLockHttpScmRequestHandler(this.i18nService, this.repositoryService, new DefaultUpstreamLfsClient(this.i18nService, this.jsonRenderer, this.context, this.requestManager));
    }
}

