/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock;

import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockListRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLock;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.UnrestrictedAccess;
import com.sun.jersey.spi.resource.Singleton;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/locks")
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GitLfsLockResource {
    private final LfsLockService lfsLockService;

    public GitLfsLockResource(@Nonnull LfsLockService lfsLockService) {
        this.lfsLockService = lfsLockService;
    }

    @GET
    public Response getLocks(@Context Repository repository, @Context PageRequest pageRequest, @QueryParam(value="path") String path) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.endsWith((CharSequence)path, (CharSequence)"/")) {
            Page<LfsLock> locks = this.lfsLockService.listLocksByDirectory(repository, StringUtils.defaultString((String)path), pageRequest);
            return this.toRestLfsLockResponse(locks);
        }
        Page<LfsLock> locks = this.lfsLockService.listLocks(new LfsLockListRequest.Builder(repository).path(path).sendAnalytics(false).build(), pageRequest);
        return this.toRestLfsLockResponse(locks);
    }

    private Response toRestLfsLockResponse(Page<LfsLock> locks) {
        return ResponseFactory.ok().entity((Object)new RestPage(locks, RestLfsLock::new)).build();
    }
}

