/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ResponseActionsObject
extends ResponseObject {
    private final Map<ResponseActionType, ResponseAction> actions = new HashMap<ResponseActionType, ResponseAction>();

    public ResponseActionsObject(@Nonnull String oid, long size, @Nonnull Collection<ResponseAction> actions) {
        super(oid, size);
        actions.forEach(action -> {
            if (this.actions.put(action.getType(), (ResponseAction)action) != null) {
                throw new IllegalArgumentException("Multiple actions with equal operation type: " + (Object)((Object)action.getType()));
            }
        });
    }

    @Nonnull
    public Optional<ResponseAction> getAction(@Nonnull ResponseActionType type) {
        return Optional.ofNullable(this.actions.get((Object)Objects.requireNonNull(type, "type")));
    }

    @Nonnull
    public Collection<ResponseAction> getActions() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

