/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.LfsDigestUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class DigestValidatingOutputStream
extends DigestOutputStream {
    private final String desiredChecksum;
    private final Path objectFile;
    private final AtomicBoolean validated;

    public DigestValidatingOutputStream(OutputStream delegate, Path objectFile) {
        super(delegate, DigestUtils.getSha256Digest());
        this.objectFile = Objects.requireNonNull(objectFile, "objectFile");
        this.desiredChecksum = LfsFileSystemHelper.extractOid(objectFile);
        this.validated = new AtomicBoolean(false);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.validated.compareAndSet(false, true)) {
            LfsDigestUtils.validate(this.getCalculatedChecksum(), this.desiredChecksum, this.objectFile);
        }
    }

    public String getCalculatedChecksum() {
        return Hex.encodeHexString((byte[])this.digest.digest());
    }
}

