/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.http.HttpScmRequestHandler;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;

public abstract class BaseLfsHttpScmRequestHandler
implements HttpScmRequestHandler {
    protected final I18nService i18nService;
    protected final RepositoryService repositoryService;

    public BaseLfsHttpScmRequestHandler(@Nonnull RepositoryService repositoryService, @Nonnull I18nService i18nService) {
        this.repositoryService = Objects.requireNonNull(repositoryService, "repositoryService");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
    }

    protected Repository getRepositoryOrThrow(Matcher matcher) {
        String projectKey = matcher.group("project");
        String repositorySlug = matcher.group("repo");
        return this.getRepositoryOrThrow(projectKey, repositorySlug);
    }

    protected Repository getRepositoryOrThrow(String projectKey, String repositorySlug) {
        Repository repository;
        try {
            repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
        }
        catch (RepositoryMovedException e) {
            repository = e.getRepository();
        }
        if (repository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.nosuchrepo", new Object[]{projectKey, repositorySlug}), null);
        }
        return repository;
    }
}

