/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class BaseLfsHttpScmRequest
implements HttpScmRequest {
    protected final AuthenticationContext authenticationContext;
    protected final I18nService i18nService;
    protected final Repository repository;
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;

    public BaseLfsHttpScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.request = Objects.requireNonNull(request, "request");
        this.response = Objects.requireNonNull(response, "response");
    }

    public ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public boolean isWrite() {
        return false;
    }

    public void sendError(@Nonnull String summary, @Nonnull String detailMessage) throws IOException {
        LfsHttpScmUtils.sendError(this.response, 422, summary + "\n\n" + detailMessage);
    }
}

