/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchResponseException;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionsObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseErrorObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestBaseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestResponseActions;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestResponseError;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestResponseObject
extends RestBaseObject {
    private static final String ACTIONS_KEY = "actions";
    private static final String ERROR_KEY = "error";

    public RestResponseObject(@Nonnull ResponseObject responseObject) {
        super(responseObject);
        if (responseObject instanceof ResponseActionsObject) {
            this.constructActions((ResponseActionsObject)responseObject);
        } else if (responseObject instanceof ResponseErrorObject) {
            this.constructError((ResponseErrorObject)responseObject);
        } else {
            throw new RuntimeException("Unhandled response object type: " + responseObject.getClass().getName());
        }
    }

    protected RestResponseObject(@Nonnull Map<String, Object> values) {
        super(values);
    }

    @Nonnull
    public static RestResponseObject valueOf(@Nonnull Map<String, Object> values) {
        return new RestResponseObject(values);
    }

    @Nonnull
    public ResponseObject fromRest() {
        String oid = this.getOid();
        long size = this.getSize();
        Map errorMap = (Map)this.get(ERROR_KEY);
        Map actionsMap = (Map)this.get(ACTIONS_KEY);
        if (errorMap != null && actionsMap != null) {
            throw new BadBatchResponseException("Response for ''" + oid + "'' contains both error and actions");
        }
        if (errorMap != null) {
            RestResponseError restResponseError = RestResponseError.valueOf(errorMap);
            return new ResponseErrorObject(oid, size, restResponseError.getCode(), restResponseError.getMessage());
        }
        List<ResponseAction> actions = RestResponseActions.valueOf(actionsMap).fromRest();
        return new ResponseActionsObject(oid, size, actions);
    }

    private void constructActions(ResponseActionsObject action) {
        this.put(ACTIONS_KEY, (Object)new RestResponseActions(action.getActions()));
    }

    private void constructError(ResponseErrorObject error) {
        this.put(ERROR_KEY, (Object)new RestResponseError(error.getErrorCode(), error.getMessage()));
    }

    private String getOid() {
        String oid = this.getStringProperty("oid");
        if (oid == null) {
            throw new BadBatchResponseException("Missing ''oid'' attribute");
        }
        return oid;
    }

    private long getSize() {
        if (!this.containsKey("size")) {
            throw new BadBatchResponseException("Missing ''size'' attribute");
        }
        try {
            return this.getLongProperty("size");
        }
        catch (NumberFormatException e) {
            throw new BadBatchResponseException("Invalid size attribute");
        }
    }
}

