/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.protocol;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class GitPackets {
    private static final byte[] DELIM = "0001".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DONE = "0008done".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DONE_LINE = "0009done\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] FLUSH = "0000".getBytes(StandardCharsets.UTF_8);

    private GitPackets() {
    }

    @Nonnull
    public static byte[] create(@Nonnull String value) {
        byte[] valueBytes = value.getBytes(Charsets.UTF_8);
        String length = StringUtils.leftPad((String)Integer.toHexString(valueBytes.length + 4), (int)4, (String)"0");
        byte[] packet = new byte[valueBytes.length + 4];
        System.arraycopy(length.getBytes(Charsets.UTF_8), 0, packet, 0, 4);
        System.arraycopy(valueBytes, 0, packet, 4, valueBytes.length);
        return packet;
    }

    @Nonnull
    public static byte[] getDelim() {
        return (byte[])DELIM.clone();
    }

    @Nonnull
    public static byte[] getFlush() {
        return (byte[])FLUSH.clone();
    }

    public static boolean isDelim(byte[] packet) {
        return Arrays.equals(DELIM, packet);
    }

    public static boolean isDone(byte[] packet) {
        return packet != null && Arrays.equals(DONE, packet) || Arrays.equals(DONE_LINE, packet);
    }

    public static boolean isFlush(byte[] packet) {
        return packet != null && Arrays.equals(FLUSH, packet);
    }

    @Nullable
    public static byte[] readPacket(@Nonnull InputStream inputStream) throws IOException {
        int packetSize;
        byte[] packetSizeBuffer = new byte[4];
        int read = GitPackets.readIntoBuffer(Objects.requireNonNull(inputStream, "inputStream"), packetSizeBuffer, 0, 4);
        if (read == -1) {
            return null;
        }
        GitPackets.checkBytesRead(4, read);
        String packetSizeString = new String(packetSizeBuffer, Charsets.UTF_8);
        try {
            packetSize = Integer.parseInt(packetSizeString, 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("This does not appear to be a git packet stream; packet size was: " + packetSizeString);
        }
        if (packetSize <= 4) {
            return packetSizeBuffer;
        }
        byte[] packet = new byte[packetSize];
        System.arraycopy(packetSizeBuffer, 0, packet, 0, 4);
        read = GitPackets.readIntoBuffer(inputStream, packet, 4, packetSize - 4);
        GitPackets.checkBytesRead(packetSize - 4, read);
        return packet;
    }

    @Nonnull
    public static String toLine(byte[] packet) {
        if (packet == null || packet.length < 4) {
            throw new IllegalArgumentException("Git packets need to be at least 4 bytes long");
        }
        return new String(packet, 4, packet.length - 4, StandardCharsets.UTF_8);
    }

    private static void checkBytesRead(int expectedBytesRead, int actualBytesRead) throws IOException {
        if (expectedBytesRead != actualBytesRead) {
            throw new IOException("Premature EOF detected. Expected " + expectedBytesRead + " bytes, but only " + actualBytesRead + " were available");
        }
    }

    private static int readIntoBuffer(InputStream inputStream, byte[] buffer, int startIndex, int length) throws IOException {
        int read;
        int offset;
        int endIndex = offset + length;
        for (offset = startIndex; offset < endIndex && (read = inputStream.read(buffer, offset, endIndex - offset)) != -1; offset += read) {
        }
        return offset == startIndex ? -1 : offset - startIndex;
    }
}

